/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.monitoring;

import csbase.client.facilities.monitoring.DynamicInfoHandler;
import csbase.client.util.MonitoringTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JPanel;

public class StarCanvas
extends JPanel {
    private final int pixelsMargin = 30;
    private boolean drawName = false;
    private boolean drawPerc = false;
    private boolean drawRef = false;
    private boolean drawScale = true;
    private boolean drawRadius = false;
    private boolean drawRegions = true;
    private int factor = 1;
    private DynamicInfoHandler infoHandler = null;

    public void setInfoHandler(DynamicInfoHandler infoHandler) {
        this.infoHandler = infoHandler;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawGraph(g.create());
    }

    public void setNameState(boolean state) {
        this.drawName = state;
        this.repaint();
    }

    public void setPercState(boolean state) {
        this.drawPerc = state;
        this.repaint();
    }

    public void setRefState(boolean state) {
        this.drawRef = state;
        this.repaint();
    }

    public void setScaleState(boolean state) {
        this.drawScale = state;
        this.repaint();
    }

    public void setRadiusState(boolean state) {
        this.drawRadius = state;
        this.repaint();
    }

    public void setRegionsState(boolean state) {
        this.drawRegions = state;
        this.repaint();
    }

    public void setFactor(int factor) {
        this.factor = factor;
        this.repaint();
    }

    private void drawAxis(Graphics graphics, int cx, int cy, int radius) {
        int height = this.getHeight();
        int y = height - 30;
        graphics.setColor(MonitoringTheme.getAxisColor());
        int minx = cx - radius / 2;
        int maxx = cx + radius / 2;
        graphics.drawLine(minx, y, maxx, y);
        graphics.drawLine(minx, y - 1, maxx, y - 1);
        int value = 100;
        boolean flag = false;
        for (int r = radius; r > 0; r -= radius / 10) {
            int x1 = cx - r / 2;
            int x2 = cx + r / 2;
            if (value != 0) {
                graphics.drawLine(x1, y - 2, x1, y + 2);
                graphics.drawLine(x2, y - 2, x2, y + 2);
            }
            if (flag) {
                String str = value + "";
                graphics.drawString(str, x1 - 5, y + 13);
                graphics.drawString(str, x2 - 5, y + 13);
            }
            flag = !flag;
            value -= 10;
        }
        int asize = 12;
        graphics.fillPolygon(new Polygon(new int[]{minx, minx, minx - 12, minx}, new int[]{y, y - 6, y, y + 6}, 4));
        graphics.fillPolygon(new Polygon(new int[]{maxx, maxx, maxx + 12, maxx}, new int[]{y, y - 6, y, y + 6}, 4));
    }

    private void drawScales(Graphics graphics, int cx, int cy, int radius) {
        graphics.setColor(MonitoringTheme.getGridColor());
        if (this.drawScale) {
            for (int r = radius; r >= 0; r -= radius / 10) {
                graphics.drawArc(cx - r / 2, cy - r / 2, r, r, 0, 360);
            }
        } else {
            int r = radius;
            graphics.drawArc(cx - r / 2, cy - r / 2, r, r, 0, 360);
        }
    }

    private void drawData(Graphics graphics, int cx, int cy, int radius) {
        int i;
        int numNodes = this.infoHandler.getValidSize();
        int angle = 360 / numNodes;
        int[] xp = new int[numNodes];
        int[] yp = new int[numNodes];
        int nextNode = -1;
        for (i = 0; i < numNodes; ++i) {
            int r;
            ++nextNode;
            double a = i * angle;
            while (!this.infoHandler.isValid(nextNode)) {
                ++nextNode;
            }
            double load = this.infoHandler.getCurrentValue(nextNode);
            if (load > 100.0) {
                load = 100.0;
            }
            r = (r = (int)(load / 100.0 * (double)radius / 2.0)) > radius ? radius : r;
            xp[i] = cx + (int)(Math.cos(Math.toRadians(a)) * (double)r);
            yp[i] = cy + (int)(Math.sin(Math.toRadians(a)) * (double)r);
        }
        graphics.setColor(MonitoringTheme.getProcessorColor());
        graphics.fillPolygon(xp, yp, numNodes);
        graphics.setColor(MonitoringTheme.getAxisColor());
        graphics.drawPolygon(xp, yp, numNodes);
        graphics.setColor(Color.BLACK);
        nextNode = -1;
        for (i = 0; i < numNodes; ++i) {
            ++nextNode;
            String txt = "";
            while (!this.infoHandler.isValid(nextNode)) {
                ++nextNode;
            }
            int load = (int)this.infoHandler.getCurrentValue(nextNode);
            if (load > 100) {
                load = 100;
            }
            if (this.drawName) {
                txt = txt + this.infoHandler.getName(nextNode) + " ";
            }
            if (this.drawPerc) {
                txt = txt + "(" + load + "%)";
            }
            graphics.drawString(txt, xp[i], yp[i]);
        }
    }

    private void drawStar(Graphics graphics, int cx, int cy, int radius) {
        if (this.drawRadius) {
            graphics.setColor(MonitoringTheme.getGridColor());
            for (int a = 0; a < 360; a += 360 / this.infoHandler.getValidSize()) {
                int x = cx + (int)(Math.cos(Math.toRadians(a)) * (double)radius * 0.55);
                int y = cy + (int)(Math.sin(Math.toRadians(a)) * (double)radius * 0.55);
                graphics.drawLine(cx, cy, x, y);
            }
        }
    }

    private void drawForeground(Graphics graphics, int cx, int cy, int radius) {
        if (this.drawRegions) {
            int r = radius;
            graphics.setColor(MonitoringTheme.getRangeAlertColor());
            graphics.fillArc(cx - r / 2, cy - r / 2, r, r, 0, 360);
            r = (int)((double)radius * 0.75);
            graphics.setColor(MonitoringTheme.getRangeWarningColor());
            graphics.fillArc(cx - r / 2, cy - r / 2, r, r, 0, 360);
            r = (int)((double)radius * 0.5);
            graphics.setColor(MonitoringTheme.getRangeNormalColor());
            graphics.fillArc(cx - r / 2, cy - r / 2, r, r, 0, 360);
        } else {
            int r = radius;
            graphics.setColor(MonitoringTheme.getRangeDefaultColor());
            graphics.fillArc(cx - r / 2, cy - r / 2, r, r, 0, 360);
        }
    }

    private void unClip(Graphics graphics) {
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setClip(0, 0, width, height);
    }

    private void clip(Graphics graphics) {
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setClip(0, 0, width, height - 30);
    }

    private void drawGraph(Graphics graphics) {
        if (this.infoHandler == null) {
            return;
        }
        if (this.infoHandler.getValidSize() < 1) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, width, height);
        int size = (width < height ? width : height) - 30;
        int cx = width / 2;
        int cy = height / 2;
        int radius = (int)((double)size * 0.9) * this.factor;
        if (this.drawRef) {
            this.clip(graphics);
        }
        this.drawForeground(graphics, cx, cy, radius);
        this.drawStar(graphics, cx, cy, radius);
        this.drawData(graphics, cx, cy, radius);
        this.drawScales(graphics, cx, cy, radius);
        if (this.drawRef) {
            this.unClip(graphics);
            this.drawAxis(graphics, cx, cy, radius);
        }
    }

    public StarCanvas() {
        Dimension size = new Dimension(500, 400);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
    }
}

