/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences;

import csbase.client.desktop.RemoteTask;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceException;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.model.Category;
import csbase.client.preferences.model.Preference;
import csbase.exception.CSBaseRuntimeException;
import csbase.exception.ServiceFailureException;
import csbase.logic.SharedObject;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.NotificationServiceInterface;
import csbase.remote.SharedObjectServiceInterface;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import tecgraf.javautils.core.lng.LNG;

class PreferencePersistence {
    private static String USER_PREFERENCE_CATEGORY = "UserPreferences";
    private static String PREFERENCES = "preferences";
    private static String CLASSPATH = "csbase.client.preferences.model";
    private static PreferencePersistence instance;

    static PreferencePersistence getInstance() {
        if (instance == null) {
            instance = new PreferencePersistence();
        }
        return instance;
    }

    void load(Window parent, PreferenceCategory root) {
        String preferenceAsStr = this.loadSharedObject(parent);
        Category tree = this.xml2Tree(preferenceAsStr);
        this.setUserPreferences(tree, root);
    }

    void save(Window parent, PreferenceCategory root) {
        Category tree = new Category();
        this.convert2Tree(tree, root);
        String xml = this.tree2Xml(tree);
        this.saveSharedObject(xml, parent);
    }

    private void convert2Tree(Category category, PreferenceCategory pc) {
        category.setId(pc.getId());
        for (Map.Entry<String, PreferenceValue<?>> entry : pc.getPreferencesMap().entrySet()) {
            String prefName = entry.getKey();
            PreferenceValue<?> prefValue = entry.getValue();
            Preference p = new Preference();
            p.setName(prefName);
            p.setValue(prefValue.toString());
            p.setType(prefValue.getClassName());
            p.setPolicy(prefValue.getPolicy().toString());
            category.getPreferences().add(p);
        }
        for (PreferenceCategory aux : pc.getCategories()) {
            Category c = new Category();
            this.convert2Tree(c, aux);
            category.getCategories().add(c);
        }
    }

    private void setUserPreferences(Category tree, PreferenceCategory node) {
        for (Preference p : tree.getPreferences()) {
            PreferenceValue<?> pv = node.getPreference(p.getName());
            if (pv == null || !pv.getClassName().equals(p.getType())) continue;
            pv.setValueAsStr(p.getValue());
        }
        for (Category c : tree.getCategories()) {
            PreferenceCategory pc = node.getCategory(c.getId());
            if (pc == null) continue;
            this.setUserPreferences(c, pc);
        }
    }

    private Category xml2Tree(String preferences) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)CLASSPATH);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StreamSource ss = new StreamSource(new StringReader(preferences));
            JAXBElement result = unmarshaller.unmarshal((Source)ss, Category.class);
            return (Category)result.getValue();
        }
        catch (JAXBException e) {
            throw new PreferenceException("N\u00e3o foi poss\u00edvel construir as prefer\u00eancias dado o XML:" + preferences, e);
        }
    }

    private String tree2Xml(Category root) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)CLASSPATH);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            marshaller.marshal((Object)root, (OutputStream)os);
            return os.toString();
        }
        catch (JAXBException e) {
            throw new PreferenceException("N\u00e3o foi poss\u00edvel converter o objeto de prefer\u00eancias para XML.", e);
        }
    }

    private String loadSharedObject(Window parent) {
        ReadSharedObjectTask task = new ReadSharedObjectTask();
        boolean result = task.execute(parent, this.getString("title"), this.getString("load"));
        if (result) {
            return (String)task.getResult();
        }
        throw new PreferenceException("N\u00e3o foi poss\u00edvel carregar o sharedObject de prefer\u00eancias.");
    }

    private void saveSharedObject(final String preferences, Window parent) {
        final SharedObjectServiceInterface sharedObjectService = ClientRemoteLocator.sharedObjectService;
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                SharedObject sharedObject = new SharedObject(USER_PREFERENCE_CATEGORY, User.getLoggedUser().getId(), PREFERENCES, false, (Object)preferences);
                sharedObjectService.saveSharedObject(sharedObject);
            }
        };
        task.execute(parent, this.getString("title"), this.getString("save"));
    }

    private String getString(String key) {
        return LNG.get((String)(this.getClass().getSimpleName() + "." + key));
    }

    private PreferencePersistence() {
    }

    private class ReadSharedObjectTask
    extends RemoteTask<String> {
        private ReadSharedObjectTask() {
        }

        protected void performTask() throws Exception {
            SharedObjectServiceInterface sharedObjectService = ClientRemoteLocator.sharedObjectService;
            SharedObject sharedObject = sharedObjectService.getSharedObject(USER_PREFERENCE_CATEGORY, User.getLoggedUser().getId(), PREFERENCES);
            if (sharedObject == null) {
                this.setResult(null);
            } else {
                this.setResult(sharedObject.getContents().toString());
            }
        }

        @Override
        protected void handleServerError(CSBaseRuntimeException cserror) {
            if (cserror instanceof ServiceFailureException) {
                try {
                    SharedObjectServiceInterface sharedObjectService = ClientRemoteLocator.sharedObjectService;
                    sharedObjectService.removeSharedObject(USER_PREFERENCE_CATEGORY, PREFERENCES);
                    NotificationServiceInterface notificationService = ClientRemoteLocator.notificationService;
                    Object[] userIds = new Object[]{User.getLoggedUser().getId()};
                    notificationService.notifyTo(userIds, LNG.get((String)"notification.data.reset.preference"), false, false);
                }
                catch (RemoteException e) {
                    super.handleError(e);
                }
            } else {
                super.handleServerError(cserror);
            }
        }
    }
}

