/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.Platform;
import csbase.logic.PlatformInfo;
import java.awt.Window;
import java.util.Vector;
import tecgraf.javautils.core.lng.LNG;

public class PlatformProxy {
    public static Vector<Platform> getAllPlatforms(Window owner, String title, String message) {
        RemoteTask<Vector<Platform>> task = new RemoteTask<Vector<Platform>>(){

            public void performTask() throws Exception {
                this.setResult(new Vector(Platform.getAllPlatforms()));
            }
        };
        if (task.execute(owner, title, message)) {
            Vector platformsVector = (Vector)task.getResult();
            if (platformsVector == null || platformsVector.size() <= 0) {
                return new Vector<Platform>();
            }
            return platformsVector;
        }
        return new Vector<Platform>();
    }

    public static Platform getPlatform(Window owner, String title, String message, final Object platformId) {
        RemoteTask<Platform> task = new RemoteTask<Platform>(){

            public void performTask() throws Exception {
                this.setResult(Platform.getPlatform((Object)platformId));
            }
        };
        task.execute(owner, title, message);
        return (Platform)task.getResult();
    }

    public static Platform createPlatform(Window owner, String title, String message, final PlatformInfo info) {
        RemoteTask<Platform> task = new RemoteTask<Platform>(){

            public void performTask() throws Exception {
                this.setResult(Platform.createPlatform((PlatformInfo)info));
            }
        };
        if (task.execute(owner, title, message)) {
            Platform platform = (Platform)task.getResult();
            if (platform == null) {
                StandardErrorDialogs.showErrorDialog(owner, title, LNG.get((String)"IAS_PLATFORM_ALREADY_EXISTS_ERROR"));
            }
            return platform;
        }
        return null;
    }

    public static Platform modifyPlatform(Window owner, String title, String message, final Object platformId, final PlatformInfo info) {
        RemoteTask<Platform> task = new RemoteTask<Platform>(){

            public void performTask() throws Exception {
                this.setResult(Platform.modifyPlatform((Object)platformId, (PlatformInfo)info));
            }
        };
        if (task.execute(owner, title, message)) {
            Platform platform = (Platform)task.getResult();
            if (platform == null) {
                StandardErrorDialogs.showErrorDialog(owner, title, LNG.get((String)"IAS_PLATFORM_ALREADY_EXISTS_ERROR"));
            }
            return platform;
        }
        return null;
    }

    public static void deletePlatform(Window owner, String title, String message, final Object platformId) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                Platform.deletePlatform((Object)platformId);
            }
        };
        task.execute(owner, title, message);
    }
}

