/*
 * $Id:$
 */
package csbase.client.applications.xmlviewer.styles;

import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;

import org.w3c.dom.Node;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.xmlpanel.XMLPanelUtils;

/**
 * Estilo padro do WebSintesi
 * 
 * @author Tecgraf/PUC-Rio
 */
public class XMLPanelStyleFlow extends XMLPanelStyle {
  /**
   * Constante textual para busca de: nome de atributo
   */
  private static final String LABEL = "rotulo";

  /**
   * Constante textual para busca de: nome de atributo
   */
  private static final String OUTPUT = "saida";

  /**
   * Constante textual para busca de: nome de atributo
   */
  private static final String INPUT = "entrada";

  /**
   * Constante textual para busca de: nome de entidade (n)
   */
  private static final String CONNECTION = "conexao";

  /**
   * Constante textual para busca de: nome de entidade (n)
   */
  private static final String PARAM = "parametro";

  /**
   * Constante textual para busca de: nome de atributo
   */
  private static final String VERSION = "versao";

  /**
   * Constante textual para busca de: nome de entidade (n) e atributo.
   */
  private static final String NODE = "no";

  /**
   * Constante textual para busca de: nome de entidade (n)
   */
  private static final String ALGORITHM = "algoritmo";

  /**
   * Constante textual para busca de: nome de entidade (n)
   */
  private static final String ID = "id";

  /**
   * Constante textual para busca de: nome de entidade (n)
   */
  private static final String NAME = "nome";

  /**
   * Constante textual para busca de: nome de entidade (n)
   */
  private static final String FLOW = "fluxo";

  /**
   * {@inheritDoc}
   */
  @Override
  public String getTreeText(final Node node, final String textValue,
    final int index) {
    if (textValue.equals(FLOW)) {
      String nTxt = XMLPanelUtils.getAttributeValue(node, NAME);
      return nTxt;
    }
    else if (textValue.equals(NODE)) {
      String idTxt = XMLPanelUtils.getAttributeValue(node, ID);
      String nTxt =
        XMLPanelUtils.getFirstChildAttributeValue(node, ALGORITHM, NAME);

      return "Id:" + idTxt + " - " + nTxt;
    }
    else if (textValue.equals(ALGORITHM)) {
      String nTxt = XMLPanelUtils.getAttributeValue(node, NAME);
      String vTxt = XMLPanelUtils.getAttributeValue(node, VERSION);
      return nTxt + " (" + vTxt + ")";
    }
    else if (textValue.equals(PARAM)) {
      String nTxt = XMLPanelUtils.getAttributeValue(node, NAME);
      String rTxt = XMLPanelUtils.getAttributeValue(node, LABEL);
      return nTxt + " - " + rTxt;
    }
    else if (textValue.equals(CONNECTION)) {
      String frTxt =
        XMLPanelUtils.getFirstChildAttributeValue(node, INPUT, NODE);
      String toTxt =
        XMLPanelUtils.getFirstChildAttributeValue(node, OUTPUT, NODE);
      if (frTxt == null) {
        frTxt = "#ERROR";
      }
      if (toTxt == null) {
        toTxt = "#ERROR";
      }

      return frTxt + " \u2192 " + toTxt;
    }
    return textValue;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getIcon(final Node node, final String textValue,
    final int index) {
    if (textValue.equals(FLOW)) {
      return ApplicationImages.ICON_FLOW_16;
    }
    else if (textValue.equals(NODE)) {
      return ApplicationImages.ICON_FLOW_NODE_16;
    }
    else if (textValue.equals(ALGORITHM)) {
      return ApplicationImages.ICON_ALGORITHM_16;
    }
    else if (textValue.equals(PARAM)) {
      return ApplicationImages.ICON_PARAMETER_16;
    }
    else if (textValue.equals(CONNECTION)) {
      return ApplicationImages.ICON_FLOW_CONNECTION_16;
    }
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<String> getTipicalFileTypes() {
    final ArrayList<String> list = new ArrayList<String>();
    list.add("FLX");
    return list;
  }

  /**
   * Construtor
   */
  public XMLPanelStyleFlow() {
  }
}
