package csbase.client.preferences.util;

import java.util.EventListener;

/**
 * Interface que define o ouvinte de uma preferncia.
 * 
 * @param <T> tipo do valor armazenado na preferncia.
 * 
 * @author Tecgraf
 */
public interface PreferenceListener<T> extends EventListener {

  /**
   * Executado sempre que um valor de preferncia for alterado.
   * 
   * @param oldValue valor da preferncia antes da mudana.
   * @param newValue valor da preferncia aps a mudana.
   */
  void valueChanged(T oldValue, T newValue);

}
