package csbase.client.rest.resources.v1.authentication;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;

import tecgraf.javautils.version.VersionNumber;

import csbase.client.Client;
import csbase.client.rest.RestController;

/**
 * Responsvel pelo atendimento REST de verso do cliente.
 *
 * @author Tecgraf/PUC-Rio
 */
@Path("v1/authentication")
@Api(value = "Base", authorizations = {
    @Authorization(value = "Bearer", scopes = {}) })
public class AuthenticationRestService {

  /**
   * Consulta a verso do sistema (client-side)
   *
   * @return um texto com a verso.
   */
  @GET
  @Path("token")
  @Produces(MediaType.TEXT_PLAIN)
  @ApiOperation(value = "Get current authorization token in text plain.", notes = "This can only be done by the logged in user.")
  @ApiResponses(value = {
      @ApiResponse(code = 200, message = "Successful operation"),
  })
  public Response getAuthToken() {
    final RestController restController = RestController.getInstance();
    final String authToken = restController.getAuthToken();
    return Response.status(Status.OK).entity(authToken).build();
  }
}
