/**
 * TableColumnAttributes.java
 */
package csbase.client.util;

/**
 * A interface <code>TableColumnAttributes</code> modela os  atributos
 * configurveis de uma coluna da tabela genrica.
 */
public abstract class TableColumnAttributes extends ReversibleComparator {
  /**
   * Obtm o ttulo da coluna
   *
   * @return .
   */
  public abstract String getColumnName();

  /**
   * Obtm a representao do valor correspondente  coluna.
   *
   * @param o objeto que contm o valor a ser representado
   *
   * @return representao do valor exibido na coluna
   */
  public abstract Object getColumnValue(Object o);
  
  /**
   * Altera a representao do valor correspondente  coluna.
   *
   * @param o objeto que contm valor a ser alterado.
   * @param value novo valor.
   */
  public abstract void setColumnValue(Object o, Object value);

}
