/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.columns;

import csbase.client.ClientLocalFile;
import csbase.client.applications.ApplicationImages;
import csbase.client.util.csvpanel.columns.FileChooserListener;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.logic.ClientFile;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class ClientFileChooserTextPanel
extends JPanel {
    private ClientFile selectedFile;
    private Window owner;
    private String fileType;
    private ClientFileChooserType chooserType;
    private ClientFileChooserSelectionMode mode;
    private JTextField configurationFileField;
    private ClientFileLocation location;
    private final List<FileChooserListener> listeners;

    public ClientFileChooserTextPanel(ClientFile initialValue, Window owner, String fileType, ClientFileChooserType chooserType, ClientFileChooserSelectionMode mode, ClientFileLocation location) {
        this.owner = owner;
        this.fileType = fileType;
        this.chooserType = chooserType;
        this.mode = mode;
        this.location = location;
        this.configurationFileField = new JTextField(30);
        this.listeners = new ArrayList<FileChooserListener>();
        this.createContents();
        this.setSelectedFile(initialValue);
    }

    public ClientFileChooserTextPanel(Window owner, String fileType, ClientFileChooserType chooserType, ClientFileChooserSelectionMode mode, ClientFileLocation location) {
        this(null, owner, fileType, chooserType, mode, location);
    }

    private void createContents() {
        GBC gbc = new GBC().insets(5, 5, 5, 5).west().weighty(1.0);
        this.configurationFileField.setEditable(false);
        int gridx = 1;
        this.add((Component)this.configurationFileField, new GBC(gbc).right(0).gridy(1).gridx(gridx).horizontal());
        gbc = gbc.right(1).left(0).gridy(1);
        if (this.location != ClientFileLocation.LOCAL_ONLY) {
            JButton browseButton = this.createBrowseProjectButton();
            this.add((Component)browseButton, new GBC(gbc).gridx(++gridx));
        }
        if (this.location != ClientFileLocation.PROJECT_ONLY) {
            JButton browseLocalButton = this.createBrowseLocalButton();
            this.add((Component)browseLocalButton, new GBC(gbc).gridx(++gridx));
        }
    }

    private JButton createBrowseLocalButton() {
        JButton browseLocalButton = GUIUtils.createImageButton((Icon)ApplicationImages.ICON_BROWSELOCALFILE_16);
        browseLocalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ArrayList<String> fileCodes = new ArrayList<String>();
                fileCodes.add(ClientFileChooserTextPanel.this.fileType);
                ClientLocalFile file = null;
                switch (ClientFileChooserTextPanel.this.chooserType) {
                    case SAVE: {
                        if (ClientFileChooserTextPanel.this.mode != ClientFileChooserSelectionMode.FILES_ONLY) break;
                        file = ClientLocalFileChooserUtil.browseSingleFileInSaveMode(ClientFileChooserTextPanel.this.owner, fileCodes, ClientFileChooserTextPanel.this.fileType, null, false, null);
                        break;
                    }
                    case OPEN: {
                        file = ClientFileChooserTextPanel.this.mode == ClientFileChooserSelectionMode.FILES_ONLY ? ClientLocalFileChooserUtil.browseSingleFileInOpenMode(ClientFileChooserTextPanel.this.owner, fileCodes, null, false, null) : ClientLocalFileChooserUtil.browseSingleDirectoryInOpenMode(ClientFileChooserTextPanel.this.owner, fileCodes, null, false, null);
                    }
                }
                if (file != null) {
                    ClientFileChooserTextPanel.this.setSelectedFile(file);
                    ClientFileChooserTextPanel.this.notifySelection(ClientFileChooserTextPanel.this.selectedFile);
                }
            }
        });
        return browseLocalButton;
    }

    private JButton createBrowseProjectButton() {
        JButton browseButton = GUIUtils.createImageButton((Icon)ApplicationImages.ICON_BROWSEFILE_16);
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ClientProjectFileChooserUtil.OperationResult result = null;
                switch (ClientFileChooserTextPanel.this.chooserType) {
                    case SAVE: {
                        if (ClientFileChooserTextPanel.this.mode != ClientFileChooserSelectionMode.FILES_ONLY) break;
                        result = ClientProjectFileChooserUtil.browseSingleFileInSaveMode(ClientFileChooserTextPanel.this.owner, ClientFileChooserTextPanel.this.fileType, null, false, null, true);
                        break;
                    }
                    case OPEN: {
                        result = ClientFileChooserTextPanel.this.mode == ClientFileChooserSelectionMode.FILES_ONLY ? ClientProjectFileChooserUtil.browseSingleFileInOpenMode(ClientFileChooserTextPanel.this.owner, ClientFileChooserTextPanel.this.fileType, null, false) : ClientProjectFileChooserUtil.browseSingleDirectoryInOpenMode(ClientFileChooserTextPanel.this.owner, ClientFileChooserTextPanel.this.fileType, null, false, null);
                    }
                }
                if (result != null) {
                    ClientFileChooserTextPanel.this.setSelectedFile((ClientFile)result.getClientProjectFile());
                    ClientFileChooserTextPanel.this.notifySelection(ClientFileChooserTextPanel.this.selectedFile);
                }
            }
        });
        return browseButton;
    }

    public ClientFile getSelectedFile() {
        return this.selectedFile;
    }

    protected void setSelectedFile(ClientFile selectedFile) {
        this.selectedFile = selectedFile;
        String path = null;
        if (selectedFile != null) {
            path = selectedFile.getStringPath();
        }
        this.configurationFileField.setText(path);
    }

    private void notifySelection(ClientFile file) {
        for (FileChooserListener listener : this.listeners) {
            listener.fileSelected(file);
        }
    }

    public void addFileSelectionListener(FileChooserListener listener) {
        this.listeners.add(listener);
    }

    public void removeFileSelectionListener(FileChooserListener listener) {
        this.listeners.remove(listener);
    }

    public static enum ClientFileLocation {
        LOCAL_ONLY,
        PROJECT_ONLY,
        ANY;

    }
}

