/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui;

import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

public class FilterableComboModel
extends DefaultComboBoxModel {
    Vector<Object> originalList;
    Filter filter;

    public FilterableComboModel(Vector<Object> list, Filter filter) {
        this.originalList = list;
        this.filter = filter;
        this.filter();
    }

    public void filter() {
        Object selection = this.getSelectedItem();
        super.removeAllElements();
        if (this.filter.isEnabled()) {
            for (Object elem : this.originalList) {
                if (!this.filter.accept(elem)) continue;
                super.addElement(elem);
            }
        } else {
            for (Object elem : this.originalList) {
                super.addElement(elem);
            }
        }
        if (selection != null) {
            this.setSelectedItem(selection);
        }
    }

    @Override
    public void addElement(Object object) {
        this.originalList.addElement(object);
        if (this.filter.accept(object)) {
            super.addElement(object);
        }
    }

    @Override
    public void insertElementAt(Object object, int index) {
        Object obj = super.getElementAt(index);
        int originalListIndex = this.originalList.indexOf(obj, 0);
        this.originalList.insertElementAt(obj, originalListIndex);
    }

    @Override
    public void removeElement(Object object) {
        super.removeElement(object);
        this.originalList.remove(object);
    }

    @Override
    public void removeElementAt(int index) {
        Object object = super.getElementAt(index);
        if (object != null) {
            super.removeElementAt(index);
            this.originalList.remove(object);
        }
    }

    public static abstract class Filter {
        public abstract boolean accept(Object var1);

        public abstract boolean isEnabled();
    }
}

