package csbase.client.util.table;

/**
 * Evento Ocorreu um Erro de Validao.
 * 
 * @param <R> O valor armazenado na linha da tabela.
 */
public final class ValidationErrorWasHappenedEvent<R> {
  /**
   * A mensagem de erro.
   */
  private String errorMessage;

  /**
   * Indica se a edio est ocorrendo.
   */
  private boolean isEditing;

  /**
   * A tabela.
   */
  private Table<R> table;

  /**
   * Cria o evento.
   * 
   * @param table A tabela (No aceita {@code null}).
   * @param errorMessage O erro (No aceita {@code null}).
   */
  public ValidationErrorWasHappenedEvent(Table<R> table, String errorMessage) {
    setTable(table);
    setErrorMessage(errorMessage);
  }

  /**
   * Obtm a mensagem de erro.
   * 
   * @return .
   */
  public String getErrorMessage() {
    return errorMessage;
  }

  /**
   * Obtm a tabela.
   * 
   * @return .
   */
  public Table<R> getTable() {
    return table;
  }

  /**
   * Indica se a edio est ocorrendo.
   * 
   * @return .
   */
  public boolean isEditing() {
    return isEditing;
  }

  /**
   * Atribui a mensagem de erro.
   * 
   * @param errorMessage A mensagem de erro (No aceita {@code null}).
   */
  private void setErrorMessage(String errorMessage) {
    if (errorMessage == null) {
      throw new IllegalArgumentException("O parmetro errorMessage est nulo.");
    }
    this.errorMessage = errorMessage;
  }

  /**
   * Atribui a tabela.
   * 
   * @param table A tabela (No aceita {@code null}).
   */
  private void setTable(Table<R> table) {
    if (table == null) {
      throw new IllegalArgumentException("O parmetro table est nulo.");
    }
    this.table = table;
  }
}
