/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.logviewer;

import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationProject;
import csbase.client.util.event.EventListener;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.LogPanelReloader;
import csbase.client.util.gui.log.actions.AutoReloadAction;
import csbase.client.util.gui.log.actions.CloseLogAction;
import csbase.client.util.gui.log.actions.DecPageAction;
import csbase.client.util.gui.log.actions.FirstPageAction;
import csbase.client.util.gui.log.actions.IncPageAction;
import csbase.client.util.gui.log.actions.LastPageAction;
import csbase.client.util.gui.log.actions.OpenLogAction;
import csbase.client.util.gui.log.actions.SetAutoReloadTimeAction;
import csbase.client.util.gui.log.actions.SetFontSizeAction;
import csbase.client.util.gui.log.actions.SetFontTypeAction;
import csbase.client.util.gui.log.enums.FontSize;
import csbase.client.util.gui.log.enums.FontType;
import csbase.logic.ClientProjectFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import tecgraf.javautils.gui.GBC;

public class LogViewer
extends ApplicationProject {
    private final AtomicBoolean fileNotFound = new AtomicBoolean(false);
    private final LogPanel logPanel;
    private boolean autoReload = this.getBooleanSpecificProperty("autoReload", true);

    public LogViewer(String id) {
        super(id);
        int defPageSizeKb = 100;
        String propName = "pageSizeKb";
        int pageSizeKb = this.getIntSpecificProperty("pageSizeKb", 100);
        this.logPanel = LogPanel.createLogPanelWithCompleteToolBar(pageSizeKb);
        JToolBar toolBar = this.logPanel.getToolBar();
        toolBar.addSeparator();
        toolBar.add(new ApplicationAboutAction(this));
        this.logPanel.addThrowableEventListener(new EventListener<LogPanel.ThrowableEvent>(){

            @Override
            public void eventFired(LogPanel.ThrowableEvent event) {
                LogViewer.this.getApplicationFrame().getStatusBar().setError(event.getMessage());
            }
        });
        this.logPanel.addFileEventListener(new EventListener<LogPanel.FileEvent>(){

            @Override
            public void eventFired(LogPanel.FileEvent event) {
                LogViewer.this.getApplicationFrame().getStatusBar().clearStatus();
                if (LogPanel.FileEvent.Type.NOT_FOUND == event.getType()) {
                    LogViewer.this.fileNotFound.set(true);
                    String warningMsg = LogPanel.getString("statusbar.warning.file.notFound", event.getFile().getName());
                    LogViewer.this.getApplicationFrame().getStatusBar().setWarning(warningMsg);
                } else {
                    boolean fileWasNotFound = LogViewer.this.fileNotFound.get();
                    LogViewer.this.fileNotFound.set(false);
                    LogViewer.this.getApplicationFrame().getStatusBar().clearStatus();
                    if (LogPanel.FileEvent.Type.RELOADED == event.getType() && fileWasNotFound) {
                        String warningMsg = LogPanel.getString("dialog.info.file.isBack", event.getFile().getName());
                        ApplicationFrame frame = LogViewer.this.getApplicationFrame();
                        String title = LogViewer.this.getName();
                        Object[] buttons = new String[]{LogPanel.getString("button.ok", new Object[0])};
                        JOptionPane.showOptionDialog(frame, warningMsg, title, -1, -1, null, buttons, buttons[0]);
                    }
                    if (LogViewer.this.autoReload) {
                        if (LogPanel.FileEvent.Type.CLOSED == event.getType()) {
                            LogViewer.this.logPanel.getReloader().stop();
                        } else if (LogPanel.FileEvent.Type.OPENED == event.getType()) {
                            LogViewer.this.logPanel.getReloader().start();
                        }
                    }
                }
            }
        });
        this.buildFrame(this.logPanel);
        this.configHotKeys(this.logPanel);
    }

    public final void openFile(ClientProjectFile file) {
        this.logPanel.openFile(file);
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        if (value == null) {
            return;
        }
        if (name.equals("PROJECT_FILE")) {
            ClientProjectFile file = (ClientProjectFile)value;
            this.openFile(file);
        }
    }

    @Override
    public void killApplication() {
        try {
            this.logPanel.closeFile();
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }

    private void buildFrame(LogPanel logPanel) {
        ApplicationFrame mainFrame = this.getApplicationFrame();
        mainFrame.getContentPane().setLayout(new GridBagLayout());
        mainFrame.getContentPane().add((Component)logPanel, new GBC(0, 0).both());
        mainFrame.setJMenuBar(new LogViewerMenuBar(logPanel));
        mainFrame.pack();
        mainFrame.setSize(new Dimension(800, 600));
        mainFrame.getStatusBar().showStatusBar();
    }

    private void configHotKeys(LogPanel logPanel) {
        ApplicationFrame frame = this.getApplicationFrame();
        JRootPane rootPane = frame.getRootPane();
        boolean mode = true;
        InputMap inputMap = rootPane.getInputMap(1);
        ActionMap aMap = rootPane.getActionMap();
        KeyStroke crtlO = KeyStroke.getKeyStroke(79, 128);
        inputMap.put(crtlO, crtlO.toString());
        aMap.put(crtlO.toString(), new OpenLogAction(logPanel));
    }

    class LogViewerMenuBar
    extends JMenuBar {
        LogViewerMenuBar(LogPanel logPanel) {
            this.add(this.buildFileMenu(logPanel));
            this.add(this.buildPrefsMenu(logPanel));
            this.add(this.buildPagingMenu(logPanel));
            this.add(this.buildHelpMenu(logPanel));
        }

        private JMenu buildFileMenu(LogPanel logPanel) {
            JMenu menu = new JMenu();
            menu.setText(LogViewer.this.getString("file.menu"));
            menu.add(new OpenLogAction(logPanel));
            menu.add(new CloseLogAction(logPanel));
            menu.addSeparator();
            menu.add(new ApplicationExitAction(LogViewer.this));
            return menu;
        }

        private JMenu buildPrefsMenu(LogPanel logPanel) {
            JMenu menu = new JMenu();
            menu.setText(LogViewer.this.getString("preferences.menu"));
            final JCheckBoxMenuItem autoItem = new JCheckBoxMenuItem();
            autoItem.setAction(new AutoReloadAction(logPanel));
            autoItem.setSelected(logPanel.getReloader().isRunning());
            logPanel.getReloader().addStatusChangedEventListener(new EventListener<LogPanelReloader.StatusChangedEvent>(){

                @Override
                public void eventFired(LogPanelReloader.StatusChangedEvent event) {
                    autoItem.setSelected(event.isRunning());
                }
            });
            menu.add(autoItem);
            JMenu timeReloadMenu = this.buildPrefsTimeMenu(logPanel);
            menu.add(timeReloadMenu);
            JMenu fontMenu = new JMenu();
            fontMenu.setText(LogViewer.this.getString("preferences.font.menu"));
            fontMenu.add(this.buildFontTypeMenu(logPanel));
            fontMenu.add(this.buildFontSizeMenu(logPanel));
            menu.add(fontMenu);
            return menu;
        }

        private JMenu buildFontTypeMenu(LogPanel logPanel) {
            JMenu menu = new JMenu();
            menu.setText(LogViewer.this.getString("preferences.font.type.menu"));
            ButtonGroup grp = new ButtonGroup();
            for (FontType tp : FontType.values()) {
                SetFontTypeAction action = new SetFontTypeAction(logPanel, tp);
                JRadioButtonMenuItem it = new JRadioButtonMenuItem(action);
                menu.add(it);
                grp.add(it);
                if (tp != logPanel.getTextArea().getFontType()) continue;
                it.setSelected(true);
            }
            return menu;
        }

        private JMenu buildFontSizeMenu(LogPanel logPanel) {
            JMenu menu = new JMenu();
            menu.setText(LogViewer.this.getString("preferences.font.size.menu"));
            ButtonGroup grp = new ButtonGroup();
            for (FontSize sz : FontSize.values()) {
                SetFontSizeAction action = new SetFontSizeAction(logPanel, sz);
                JRadioButtonMenuItem it = new JRadioButtonMenuItem(action);
                menu.add(it);
                grp.add(it);
                if (sz != logPanel.getTextArea().getFontSize()) continue;
                it.setSelected(true);
            }
            return menu;
        }

        private JMenu buildPrefsTimeMenu(LogPanel logPanel) {
            final JMenu timeReloadMenu = new JMenu();
            timeReloadMenu.setEnabled(logPanel.getReloader().isRunning());
            logPanel.getReloader().addStatusChangedEventListener(new EventListener<LogPanelReloader.StatusChangedEvent>(){

                @Override
                public void eventFired(LogPanelReloader.StatusChangedEvent event) {
                    timeReloadMenu.setEnabled(event.isRunning());
                }
            });
            String reloadPrefix = "preferences.reload.";
            String timeMenuText = LogViewer.this.getString("preferences.reload.menu");
            timeReloadMenu.setText(timeMenuText);
            SetAutoReloadTimeAction r10 = new SetAutoReloadTimeAction(logPanel, 10L);
            SetAutoReloadTimeAction r20 = new SetAutoReloadTimeAction(logPanel, 20L);
            SetAutoReloadTimeAction r60 = new SetAutoReloadTimeAction(logPanel, 60L);
            String t10 = LogViewer.this.getString("preferences.reload.10.menu");
            String t20 = LogViewer.this.getString("preferences.reload.20.menu");
            String t60 = LogViewer.this.getString("preferences.reload.60.menu");
            JRadioButtonMenuItem mn10 = new JRadioButtonMenuItem(r10);
            JRadioButtonMenuItem mn20 = new JRadioButtonMenuItem(r20);
            JRadioButtonMenuItem mn60 = new JRadioButtonMenuItem(r60);
            mn10.setText(t10);
            mn20.setText(t20);
            mn60.setText(t60);
            ButtonGroup grp = new ButtonGroup();
            grp.add(mn10);
            grp.add(mn20);
            grp.add(mn60);
            mn10.setSelected(true);
            timeReloadMenu.add(mn10);
            timeReloadMenu.add(mn20);
            timeReloadMenu.add(mn60);
            return timeReloadMenu;
        }

        private JMenu buildPagingMenu(LogPanel logPanel) {
            JMenu menu = new JMenu();
            menu.setText(LogViewer.this.getString("page.menu"));
            menu.add(new IncPageAction(logPanel));
            menu.add(new DecPageAction(logPanel));
            menu.addSeparator();
            menu.add(new FirstPageAction(logPanel));
            menu.add(new LastPageAction(logPanel));
            return menu;
        }

        private JMenu buildHelpMenu(LogPanel logPanel) {
            JMenu menu = new JMenu();
            menu.setText(LogViewer.this.getString("help.menu"));
            menu.add(new ApplicationAboutAction(LogViewer.this));
            return menu;
        }
    }
}

