/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.resourcehelpers.ApplicationUtils;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonProjectAction;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import java.awt.event.ActionEvent;
import tecgraf.javautils.core.lng.LNG;

public class CommonFileOpenAction
extends CommonProjectAction {
    private String applicationId;
    private String name;

    public CommonFileOpenAction(ProjectFileContainer container, String applicationId, String name) {
        super(container);
        this.applicationId = applicationId;
        this.name = name;
        this.putValue("Name", name);
    }

    public CommonFileOpenAction(ProjectFileContainer container) {
        super(container);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openFile(this.getSelectedFile());
    }

    public void openFile(ClientProjectFile file) {
        try {
            DesktopComponentFrame owner = DesktopFrame.getInstance().getDesktopFrame();
            if (this.applicationId != null) {
                ApplicationUtils.runApp(this.applicationId, owner, file);
            } else {
                ApplicationUtils.runPreferredApp(owner, file);
            }
        }
        catch (ApplicationException ex) {
            StandardErrorDialogs.showErrorDialog(this.getWindow(), ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return LNG.get((String)"CommonFileOpenAction.name");
        }
        return this.name;
    }
}

