package csbase.client.algorithms.parameters;

import csbase.client.util.table.CellViewFactory;
import csbase.logic.algorithms.parameters.TableColumn;

/**
 * Viso para {@link TableColumn}.
 *
 * @author Tecgraf/PUC-Rio
 *
 * @param <C> O tipo da coluna.
 * @param <V> O tipo do valor armazenado na coluna.
 */
public interface TableColumnView<V, C extends TableColumn<V>> {
  /**
   * Obtm a coluna.
   *
   * @return A coluna.
   */
  C getColumn();

  /**
   * Obtm a fbrica de vises de clulas desta viso de coluna.
   *
   * @return A fbrica.
   */
  CellViewFactory getFactory();

  /**
   * Exibe uma mensagem de erro.
   *
   *
   * @param message A mensagem.
   */
  void showErrorMessage(String message);
}
