package csbase.client.applicationmanager.resourcehelpers;

import java.nio.charset.Charset;

import tecgraf.javautils.version.VersionNumber;
import tecgraf.javautils.xml.conversion.AbstractXMLConversion;
import tecgraf.javautils.xml.conversion.exception.XMLConversionException;
import csbase.client.Client;
import csbase.client.applications.Application;

/**
 * Conversor padro para aplicativos com base em verses.
 * 
 * @author Tecgraf/PUC-Rio
 * @param <T> classe da aplicao.
 */
abstract public class AbstractApplicationXMLConversion<T extends Application>
  extends AbstractXMLConversion {

  /**
   * Aplicao associada.
   */
  final private T application;

  /**
   * Utilitrio.
   * 
   * @param <A> classe da aplicao.
   * @param application aplicativo
   * @param version verso a ser usada
   * @param tag tag
   * @return texto do DTD.
   */
  static private <A extends Application> String generateDTD(
    final A application, final String tag, final VersionNumber version) {
    final ApplicationDTDResourceHelper<A> helper =
      new ApplicationDTDResourceHelper<A>(application);
    final String dtd = helper.getVersionedFileName(tag, version);
    return dtd;
  }

  /**
   * Retorna: aplicativo; conforme atributo {@link #application}.
   * 
   * @return o valor
   */
  protected final T getApplication() {
    return application;
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   * @param toPublicId publicId de sada.
   * @param fromVersion verso inicial
   * @param toVersion verso final
   * @param tag tag
   * @throws XMLConversionException em caso de erro
   */
  protected AbstractApplicationXMLConversion(final T application,
    final String toPublicId, final String tag, final VersionNumber fromVersion,
    final VersionNumber toVersion) throws XMLConversionException {
    super(generateDTD(application, tag, fromVersion), generateDTD(application,
      tag, toVersion), getCharset());
    this.application = application;
  }

  /**
   * Busca charset do cliente e do sistema.
   * 
   * @return charset
   */
  private static Charset getCharset() {
    final Client client = Client.getInstance();
    final Charset charset = client.getSystemDefaultCharset();
    return charset;
  }
}
