/**
 * $Id$
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.logic.ClientAlgorithmFile;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import tecgraf.javautils.core.lng.LNG;

/**
 * Ao para edio de arquivo texto de documentao.
 *
 * @author Tecgraf/PUC-Rio
 */
public class EditReleaseNotesFileAction extends AbstractEditionFileAction {

  /** Informaes sobre a verso a qual ser alterada. */
  private AlgorithmVersionInfo version;

  /**
   * Construtor
   *
   * @param tree rvore que detm o n fonte da ao.
   * @param version Verso de origem do arquivo a ser alterado.
   * @param file Arquivo de documentao a ser alterado.
   */
  public EditReleaseNotesFileAction(VersionTree tree,
    AlgorithmVersionInfo version, FileInfo file) {
    super(tree, LNG.get("algomanager.menu.release.notes.edit"), file);

    this.version = version;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ClientAlgorithmFile getClientAlgorithmFile(FileInfo info) {
    if (info == null) {
      return null;
    }
    ClientAlgorithmFile file = new ClientAlgorithmFile(version.getInfo(),
      version.getId(), info.getName(), info.getPathAsArray(),
      ClientAlgorithmFile.AlgorithmFileType.RELEASE_NOTES, false);
    return file;
  }
}
