/*
 * $Id:$
 */

package csbase.client.applications.commandsmonitor.dal.xml.elements;

import java.io.IOException;
import java.io.Writer;
import java.util.List;

import tecgraf.javautils.xml.XMLElement;
import tecgraf.javautils.xml.XMLElementInterface;
import csbase.client.applications.commandsmonitor.models.ExpressionDTO;

/**
 * Elemento Expresso.
 * 
 * @author Tecgraf
 */
public class ExpressionElement extends XMLElement {

  /**
   * Consulta o nome da tag
   * 
   * @return tag
   */
  public static final String getTagName() {
    return "expression";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {
    // Retrieving the language the value is written in.
    String language;
    if (hasAttribute("language")) {
      language = getAttributeStrValue("language");
    }
    else {
      language = ExpressionDTO.getDefaultLanguage();
    }
    // Retrieving the value of the expression.
    String value = getStrValue();

    setAppObject(new ExpressionDTO(language, value));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer writer, String ident) throws IOException {
    throw new IllegalAccessError("Esse mtodo no deve ser utilizado.");
  }
}
