/*
 * $Id:$
 */

package csbase.client.applications.commandsmonitor.dal.xml.elements;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLElement;
import tecgraf.javautils.xml.XMLElementInterface;
import csbase.client.applications.commandsmonitor.models.CommandsTableDTO;

/**
 * Elemento tabela.
 * 
 * @author Tecgraf
 */
public class TableElement extends XMLElement {

  /**
   * Consulta o nome da tag
   * 
   * @return tag
   */
  public static final String getTagName() {
    return "table";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {

    // Pega o id da tabela.
    String id = getAttributeStrValue("id");

    // Pega o id do filtro.
    String filterId = getAttributeStrValue("filter");

    // Pega a ordenao.
    String attrOrderBy = "orderby";
    String orderbyColumnId = null;
    boolean ascending = false;
    if (hasAttribute(attrOrderBy)) {
      String orderby = getAttributeStrValue(attrOrderBy);
      String[] columnId_order = orderby.split("\\|");
      orderbyColumnId = columnId_order[0];
      ascending =
        columnId_order.length == 2 && "asc".equalsIgnoreCase(columnId_order[1]);
    }

    // Pega o id das colunas.
    List<String> columnsId = new ArrayList<String>();
    ImprovedXMLListIterator iterator =
      new ImprovedXMLListIterator(childrenList);
    XMLElementInterface columnElement;
    while (null != (columnElement =
      iterator.next(ColumnReferenceElement.getTagName()))) {
      String aColumnId = (String) columnElement.getAppObject();
      columnsId.add(aColumnId);
    }
    
    Long editingMinTime = null;
    String attrCellsEditingMinTime = "cells_editing_min_time";
    if (hasAttribute(attrCellsEditingMinTime)) {
      String sEditingMinTime = getAttributeStrValue(attrCellsEditingMinTime);
      editingMinTime = Long.valueOf(sEditingMinTime);
    }

    setAppObject(new CommandsTableDTO(id, filterId, columnsId, orderbyColumnId,
      ascending, editingMinTime));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer writer, String ident) throws IOException {
    throw new IllegalAccessError("Esse mtodo no deve ser utilizado.");
  }
}
