package csbase.client.applications.sgamonitor.columns;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;

/**
 * Coluna que exibe o consumo de memria RAM (em Mb) de um SGA simples.
 * 
 * @author Tecgraf
 */
public class RamMbColumn extends AbstractConfigurableColumn<SGASet> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */

  public RamMbColumn(String id, Boolean visible,
    IStringProvider stringProvider, Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return String.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGASet obj) {
    //essa coluna s  usada na tabela que monitora sga's simples
    //logo, o SGASet contm apenas um SGAInfo.
    SGAInfo node = obj.getAllInfo()[0];

    String result = NO_VALUE;
    if (node.getAlive()) {
      result = Integer.toString(node.getRAMMemoryInfoMb());
    }
    return result;
  }
}
