package csbase.client.csdk;

import java.util.Map;

import csbase.client.applicationmanager.ApplicationException;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Definio de uma fbrica de contextos do CSDK.
 */
public interface ICSDKContextFactory {

  /**
   * Cria o mapa de contextos do CSDK, que sero disponibilizados para a
   * aplicao especificada atravs do ambiente CSDK
   * {@link csdk.v1_0.api.core.ICSDKEnvironment#getContext(Class)}, indexados
   * pelas interfaces CSDK
   * que eles implementam.
   *
   * @param appInstanceId identificador da instncia da aplicao.
   * @param mainClass classe principal da aplicao.
   * @param registry o registro da aplicao.
   * @return o mapa de contextos.
   * @throws ApplicationException em caso de erro ao criar os contextos.
   */
  public Map<Class<? extends csdk.v1_0.api.core.IContext>, csdk.v1_0.api.core
    .IContext> createCSDKContexts(
    String appInstanceId,
    Class<? extends csdk.v1_0.api.application.IApplication> mainClass,
    ApplicationRegistry registry) throws ApplicationException;

  /**
   * Cria o mapa de contextos do CSDK, que sero disponibilizados para a
   * aplicao especificada atravs do ambiente CSDK
   * {@link csdk.v2.api.core.ICSDKEnvironment#getContext(Class)}, indexados
   * pelas interfaces CSDK
   * que eles implementam.
   *
   * @param appInstanceId identificador da instncia da aplicao.
   * @param mainClass classe principal da aplicao.
   * @param registry o registro da aplicao.
   * @return o mapa de contextos.
   * @throws ApplicationException em caso de erro ao criar os contextos.
   */
  public Map<Class<? extends csdk.v2.api.core.IContext>, csdk.v2.api.core
    .IContext> createCSDKv2Contexts(
    String appInstanceId,
    Class<? extends csdk.v2.api.application.IApplication> mainClass,
    ApplicationRegistry registry) throws ApplicationException;
}
