/**
 * $Id: OpenBusContext.java 155010 2014-08-04 18:16:50Z fpina $
 */
package csbase.client.csdk.v2.extras.openbus;

import java.rmi.RemoteException;
import java.util.Properties;

import csbase.client.csdk.v2.core.CSDKAbstractContext;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.logic.BusInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.OpenBusServiceInterface;
import csdk.v2.extras.context.IOpenBusContext;
import csdk.v2.extras.context.exception.InitializationException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.assistant.AssistantParams;
import tecgraf.openbus.core.ORBInitializer;

/**
 * Contexto que fornecer uma conexo ao barramento do OpenBus usando as
 * credenciais do usurio logado no cliente.
 * 
 * @author Tecgraf
 */
public class CSDKOpenBusContext extends CSDKAbstractContext implements
  IOpenBusContext {

  /**
   * Assistente que ser fornecido  aplicao solicitante.
   */
  private Assistant assistant = null;

  /**
   * Construtor.
   */
  public CSDKOpenBusContext() {
    super();
  }

  /**
   * {@inheritDoc}
   * 
   */
  @Override
  public Assistant getAssistant(AssistantParams params)
    throws InitializationException {
    if (assistant == null) {
      try {
        final OpenBusServiceInterface openBusService =
          ClientRemoteLocator.openBusService;
        if (openBusService == null) {
          final String err = getString("openbus.service.null.error");
          throw new InitializationException(err);
        }
        BusInfo busInfo = openBusService.getBusInfo();
        String host = busInfo.getHost();
        int port = busInfo.getPort();
        String password =
          ClientRemoteMonitor.getInstance().getLoginInfo().getPassword();
        String user =
          ClientRemoteMonitor.getInstance().getLoginInfo().getLoginName();
        if (params != null) {
          //Resolvendo bug de classloading.
          Properties orbProperties = new Properties();
          orbProperties.setProperty("org.omg.CORBA.ORBClass",
            "org.jacorb.orb.ORB");
          params.orb = ORBInitializer.initORB(null, orbProperties);
          assistant =
            Assistant.createWithPassword(host, port, user, password.getBytes(),
              params);
        }
        else {
          assistant =
            Assistant.createWithPassword(host, port, user, password.getBytes());
        }

      }
      catch (RemoteException e) {
        final String err = getString("openbus.service.null.error");
        throw new InitializationException(err);
      }
    }
    return assistant;
  }

  /**
   * Consulta texto internacionalizado.
   * 
   * @param key chave
   * @return texto.
   */
  private String getString(String key) {
    final String prefix = this.getClass().getSimpleName();
    return LNG.get(prefix + "." + key);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void contextDeactivated() {
    try {
      assistant.shutdown();
    }
    catch (Exception e) {
      //ignora.
    }
    finally {
      try {
        assistant.orb().shutdown(false);
      }
      catch (Exception e) {
        //ignora.
      }
    }
  }
}
