/*
 * $Id: CommonFileDownloadAction.java 150777 2014-03-19 14:16:56Z oikawa $
 */
package csbase.client.project.action;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;

import javax.swing.JFileChooser;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.externalresources.ExternalResources;
import csbase.client.project.ProjectFileContainer;
import csbase.client.remote.srvproxies.HttpProxy;
import csbase.client.remote.srvproxies.NotificationProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.User;

/**
 * Ao de download de arquivo
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CommonFileDownloadAction extends CommonProjectAction {

  /**
   * Indica se o arquivo a ser publicado foi originado da rvore do projeto ou
   * no
   */
  private boolean isFileFromTree;

  /**
   * Arquivo a ser exportado, no originado da rvore do projeto
   */
  private ClientProjectFile exportFile;

  /**
   * Construtor
   * 
   * @param container o container
   */
  public CommonFileDownloadAction(ProjectFileContainer container) {
    super(container);
    this.isFileFromTree = true;
  }

  /**
   * Constri a ao a partir de um arquivo que no est selecionado na rvore
   * do projeto.
   * 
   * @param container rvore do projeto.
   * @param file Arquivo sobre o qual a ao ser realizada.
   */
  public CommonFileDownloadAction(ProjectFileContainer container,
    ClientProjectFile file) {
    super(container);
    this.isFileFromTree = false;
    this.exportFile = file;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    ClientProjectFile file =
      (isFileFromTree) ? (ClientProjectFile) getSelectedFile()
        : this.exportFile;
    User user = User.getLoggedUser();
    CommonClientProject project = getProject();
    final Window window = getWindow();
    try {
      // Chamada ao Proxy.
      String addr = HttpProxy.getDownloadURL(project.getId(), file.getPath());
      if (addr == null) {
        StandardErrorDialogs.showErrorDialog(window,
          LNG.get("PRJ_PROJECT_FILE_DOWNLOAD_URL_ERROR"));
        return;
      }
      final URL url = new URL(addr);
      if (ExternalResources.getInstance().isEnabled()) {
        ExternalResources.getInstance().showDocument(url);
        return;
      }
      /* Tenta abrir o FileChooser. Caso nao consiga, esta rodando */
      /* como applet */
      try {
        JFileChooser chooser = new JFileChooser();
        final String errorMsg = LNG.get("PRJ_PROJECT_FILE_DOWNLOAD_IO_ERROR");
        try {
          int returnVal = chooser.showSaveDialog(window);
          if (returnVal == JFileChooser.APPROVE_OPTION) {
            File fileChoosed = chooser.getSelectedFile();
            final FileOutputStream newFile = new FileOutputStream(fileChoosed);
            final String fileName = fileChoosed.getName();
            final Object[] ids = new Object[] { user.getId() };
            Thread work = new Thread() {
              @Override
              public void run() {
                try {
                  final String title =
                    LNG.get("PRJ_PROJECT_FILE_DOWNLOAD_TITLE");

                  final Object[] args = new Object[] { fileName };
                  final String fmtStart =
                    LNG.get("PRJ_PROJECT_FILE_DOWNLOAD_START");
                  String msg = MessageFormat.format(fmtStart, args);
                  StandardDialogs.showInfoDialog(window, title, msg);

                  InputStream urlIn = url.openStream();
                  InputStream in = new BufferedInputStream(urlIn);
                  int i;
                  byte[] b = new byte[1024];
                  while ((i = in.read(b)) != -1) {
                    newFile.write(b, 0, i);
                  }
                  urlIn.close();
                  final String fmtOk =
                    LNG.get("PRJ_PROJECT_FILE_DOWNLOAD_SUCCESS");
                  msg = MessageFormat.format(fmtOk, args);
                  NotificationProxy.notifyTo(ids, msg, false, false);
                  newFile.close();
                }
                catch (Exception ex) {
                  StandardErrorDialogs.showErrorDialog(window, errorMsg, ex);
                  return;
                }
              }
            };
            work.start();
          }
        }
        catch (Exception ioEx) {
          StandardErrorDialogs.showErrorDialog(window, errorMsg, ioEx);
        }
        /* Se deu erro, e porque esta sendo chamado pelo applet */
      }

      /*
       * catch (Exception ex) { if (Client.getInstance() == null) { return; }
       * try { Client.getInstance().showDocument(url); }
       */
      catch (Exception appletEx) {
        StandardErrorDialogs.showErrorDialog(window,
          LNG.get("PRJ_PROJECT_FILE_DOWNLOAD_APPLET_ERROR"), appletEx);
      }

      // }
    }
    catch (Exception URLEx) {
      StandardErrorDialogs.showErrorDialog(window,
        LNG.get("PRJ_PROJECT_FILE_DOWNLOAD_URL_ERROR"), URLEx);
      return;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return LNG.get("PRJ_DOWNLOAD_FILE");
  }
}
