package csbase.client.rest;

import javax.ws.rs.core.Response.Status.Family;
import javax.ws.rs.core.Response.StatusType;

/**
 * Enum para status adicionais de html
 * 
 * @author flavia
 *
 */
public enum ExtendedResponseStatus implements StatusType {

  /** 422 no  possvel processar a entidade */
  UNPROCESSABLE_ENTITY(422, "Unprocessable Entity");

  /** Cdigo */
  private final int code;

  /** Motivo */
  private final String reason;

  /** Famlia */
  private Family family;

  /**
   * Construtor
   * 
   * @param statusCode Cdigo
   * @param reasonPhrase Motivo
   */
  private ExtendedResponseStatus(final int statusCode,
    final String reasonPhrase) {
    this.code = statusCode;
    this.reason = reasonPhrase;
    switch (code / 100) {
      case 1:
        this.family = Family.INFORMATIONAL;
        break;
      case 2:
        this.family = Family.SUCCESSFUL;
        break;
      case 3:
        this.family = Family.REDIRECTION;
        break;
      case 4:
        this.family = Family.CLIENT_ERROR;
        break;
      case 5:
        this.family = Family.SERVER_ERROR;
        break;
      default:
        this.family = Family.OTHER;
        break;
    }
  }

  /** {@inheritDoc} */
  @Override
  public int getStatusCode() {
    return code;
  }

  /** {@inheritDoc} */
  @Override
  public Family getFamily() {
    return family;
  }

  /** {@inheritDoc} */
  @Override
  public String getReasonPhrase() {
    return reason;
  }
}
