package csbase.client.rest;

import java.io.IOException;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;

/**
 * Filtro usado para limitar a recarga do continer a momentos em que no
 * existem requisies sendo atendidas.
 */
@Provider
public class ReloadFilter implements ContainerRequestFilter,
  ContainerResponseFilter {

  /**
   * Contador de requisies.
   */
  private static RequestCounter counter = null;

  /**
   * Obtm o contador de requisies.
   *
   * @return o contador.
   */
  static RequestCounter getCounter() {
    if (counter == null) {
      counter = new RequestCounter();
    }
    return counter;
  }

  /**
   * Contador de requisies em atendimento.
   */
  static class RequestCounter {

    /**
     * Nmero de requisies sendo atendidas no momento.
     */
    private int requests = 0;

    /**
     * Incrementa o nmero de requisies.
     */
    void inc() {
      synchronized (this) {
        requests++;
      }
    }

    /**
     * Decrementa o nmero de requisies.
     */
    void dec() {
      synchronized (this) {
        requests--;
      }
    }

    /**
     * Obtm o lock para acesso ao contador de requisies.
     *
     * @return o lock.
     */
    public Object getLock() {
      return this;
    }

    /**
     * Indica quando no existem requisies em atendimento no momento.
     *
     * @return verdadeiro se o contador de requisies est zerado ou falso,
     * caso contrrio.
     */
    public boolean isZero() {
      return requests == 0;
    }

  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void filter(
    ContainerRequestContext containerRequestContext) throws IOException {
    getCounter().inc();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void filter(ContainerRequestContext containerRequestContext,
    ContainerResponseContext containerResponseContext) throws IOException {
    getCounter().dec();
  }
}
