package csbase.client.util.csvpanel.menu;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.util.csvpanel.columns.ColumnGenerator;
import csbase.client.util.csvpanel.columns.DirectoryListingColumnGeneratorDialog;
import csbase.client.util.csvpanel.columns.SequentialColumnGeneratorDialog;
import csbase.client.util.csvpanel.table.CSVTable;

/**
 * Menu popup do gerador de colunas da tabela.
 * 
 * @author Tecgraf
 */
public class ColumnGeneratorPopupMenu extends CSVTablePopupMenu {

  /**
   * Item de menu do gerador de nmeros sequenciais.
   */
  private JMenuItem sequentialItem;
  /**
   * Item de menu do gerador de listagem de diretrios.
   */
  private JMenuItem directoryMenuItem;

  /**
   * Construtor.
   * 
   * @param table a tabela.
   */
  public ColumnGeneratorPopupMenu(CSVTable table) {
    super(table);
    createMenu();
  }

  /**
   * Cria o contedo do menu.
   */
  private void createMenu() {
    final String itemLabel = getString("generateSequentialColumn.item");
    sequentialItem = new JMenuItem(itemLabel);
    sequentialItem.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        Window window = SwingUtilities.getWindowAncestor(table);
        if (table.getSelectedRowCount() > 0
          && table.getSelectedColumnCount() == 1) {
          SequentialColumnGeneratorDialog dialog =
            new SequentialColumnGeneratorDialog(window);
          dialog.setVisible(true);
          ColumnGenerator<?> generator = dialog.getColumnGenerator();
          if (generator != null) {
            table.generateColum(generator, table.getSelectedRows(), table
              .getSelectedColumn());
          }
        }
        else {
          String message = getString("multipleColumnSelection.warning.message");
          StandardDialogs.showWarningDialog(window, itemLabel, message);
        }
      }
    });
    add(sequentialItem);
    String directoryItemLabel =
      getString("generateDirectoryListingColumn.item");
    directoryMenuItem = new JMenuItem(directoryItemLabel);
    directoryMenuItem.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        DirectoryListingColumnGeneratorDialog dialog =
          new DirectoryListingColumnGeneratorDialog(SwingUtilities
            .getWindowAncestor(table));
        dialog.setVisible(true);
        ColumnGenerator<?> generator = dialog.getColumnGenerator();
        if (generator != null) {
          table.generateColum(generator, table.getSelectedRows(), table
            .getSelectedColumn());
        }
      }
    });
    add(directoryMenuItem);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean shouldBeShown() {
    return super.shouldBeShown() && table.isEditable()
      && table.getRowCount() > 0;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void updateItemStatus() {
    //No faz nada.
  }
}
