package csbase.client.util.table;

import java.awt.Component;

import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.logic.ProgressData;

/**
 * Mostra barra de progresso. O valor esperado  entre 0 e 100. O tipo do valor
 * esperado pode ser do tipo 'Number', que inclui 'Double', 'Integer', etc, ou
 * pode tambm ser uma combinao de String + Number, vinda como um Object[]. O
 * string especificado ser ento mostrado na barra de progresso, ao invs da
 * porcentagem. Se o valor for Null ou Double.NaN, apenas o texto  mostrado, se
 * existir um.
 */
public class ProgressCellRenderer extends DefaultTableCellRenderer {

  /**
   * Barra de progresso.
   */
  private JProgressBar progressBar;

  /**
   * String que representa um valor vazio.
   */
  private String emptyValue;

  /**
   * Construtor.
   */
  public ProgressCellRenderer() {
    this(null);
  }

  /**
   * Construtor.
   * 
   * @param emptyValue valor padro a ser utilizado quando o valor da clula for
   *        {@code null}.
   */
  public ProgressCellRenderer(String emptyValue) {
    this.emptyValue = emptyValue;
    this.progressBar = new JProgressBar();
    this.progressBar.setStringPainted(true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {

    if (value == null) {
      return super.getTableCellRendererComponent(table, emptyValue, isSelected,
        hasFocus, row, column);
    }
    else if (value instanceof ProgressData) {
      // temos tanto o texto quanto o valor ... usar ambos:
      ProgressData valueData = (ProgressData) value;
      Double numberValue = valueData.getValue();
      String description = valueData.getDescription();
      if (numberValue == null || numberValue.isNaN()) {
        if (description == null) {
          description = emptyValue;
        }
        return super.getTableCellRendererComponent(table, description,
          isSelected, hasFocus, row, column);
      }
      else {
        // definir texto da barra:
        progressBar.setString(description);

        // definir valor do progresso:
        setValue(valueData.getValue());
      }
    }
    else {
      // temos apenas o valor ... criar um texto pelo valor ...
      // definir valor do progresso:
      Number number = (Number) value;
      ProgressData data = new ProgressData(number.doubleValue());
      setValue(number);

      // definir texto:
      progressBar.setString(data.getFormattedValue());
    }

    setEnabled(table.isEnabled());
    return progressBar;
  }

  /**
   * @param number - novo valor para o progresso. Null ou Double.NaN no alteram
   *        o valor.
   */
  private void setValue(Number number) {
    if (number != null && !number.equals(Double.NaN)) {
      progressBar.setValue(number.intValue());
    }
  }
}
