package csbase.client.util.table;

import java.util.List;

/**
 * Modelo de Linhas.
 * 
 * @param <R> O valor armazenado na tabela.
 *
 * @author lmoreira
 */
public interface RowModel<R> extends Iterable<R> {

  /**
   * Adiciona uma linha.
   * 
   * @param rowValue O valor da linha.
   */
  public void addRow(R rowValue);
  
  /**
   * Adiciona um observador ao modelo.
   * 
   * @param listener O observador (No aceita {@code null}).
   */
  public void addRowModelListener(RowModelListener<R> listener);
  
  /**
   * Obtm o valor de uma linha.
   * 
   * @param rowIndex O ndice da linha.
   * 
   * @return O valor da linha ({@code null} se a linha no existir).
   */
  public R getRow(int rowIndex);
  
  /**
   * Obtm a quantidade de linhas.
   * 
   * @return .
   */
  public int getRowCount();
  
  /**
   * <p>Obtm a lista de linhas.</p>
   * 
   * <p>A lista retornada  imutvel 
   * (veja {@link java.util.Collections#unmodifiableList(List)}).</p>
   * 
   * @return A lista (caso no haja elementos a lista retornada estar vazia).
   */
  public List<R> getRows();
  
  /**
   * Indice se a lista est vazia.
   * 
   * @return .
   */
  public boolean isEmpty();
  
  /**
   * Remove uma linha.
   * 
   * @param rowIndex O ndice da linha.
   * 
   * @return {@code true} sucesso ou {@code false} se a linha no existir.
   */
  public boolean removeRow(int rowIndex);
  
  /**
   * Remove um observador.
   * 
   * @param listener O observador (No aceita {@code null}).
   * 
   * @return {@code true} sucesso ou {@code false} se o observador no existir.
   */
  public boolean removeRowModelListener(RowModelListener<R> listener);
}
