/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ParameterView;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class ComponentProperties {
    private static final Map<ParameterView.Mode, ComponentProperties> COMPONENT_PROPERTIES = new HashMap<ParameterView.Mode, ComponentProperties>();
    private Color bgColor;
    private Color fgColor;
    private Border border;
    private Font font;
    private boolean isOpaque;
    private boolean isEditable;

    private ComponentProperties(Color bgColor, Color fgColor, Border border, Font font, boolean isOpaque, boolean isEditable) {
        this.bgColor = bgColor;
        this.fgColor = fgColor;
        this.border = border;
        this.font = font;
        this.isOpaque = isOpaque;
        this.isEditable = isEditable;
    }

    public static final ComponentProperties getInstance(ParameterView.Mode mode) {
        return COMPONENT_PROPERTIES.get((Object)mode);
    }

    public static final void setProperties(JTextComponent component, ParameterView.Mode mode, boolean setBorder) {
        ComponentProperties properties = ComponentProperties.getInstance(mode);
        component.setEditable(properties.isEditable());
        ComponentProperties.setProperties((JComponent)component, properties, setBorder);
    }

    public static final void setProperties(JComponent component, ParameterView.Mode mode, boolean setBorder) {
        ComponentProperties properties = ComponentProperties.getInstance(mode);
        ComponentProperties.setProperties(component, properties, setBorder);
    }

    public static final void setProperties(JComponent component, ComponentProperties properties, boolean setBorder) {
        component.setBackground(properties.getBackground());
        component.setForeground(properties.getForeGround());
        component.setFont(properties.getFont());
        component.setOpaque(properties.isOpaque());
        if (setBorder) {
            component.setBorder(properties.getBorder());
        }
    }

    public Color getBackground() {
        return this.bgColor;
    }

    public Color getForeGround() {
        return this.fgColor;
    }

    public Border getBorder() {
        return this.border;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    private static ComponentProperties createComponentProperties(ParameterView.Mode mode) {
        JTextField template = new JTextField();
        template.setEditable(ParameterView.Mode.CONFIGURATION == mode);
        Color bgColor = template.getBackground();
        Color fgColor = template.getForeground();
        Font font = template.getFont();
        boolean isOpaque = template.isOpaque();
        boolean isEditable = template.isEditable();
        Color borderColor = ParameterView.Mode.CONFIGURATION == mode ? new Color(122, 138, 153) : new Color(184, 207, 229);
        Border border = BorderFactory.createLineBorder(borderColor);
        return new ComponentProperties(bgColor, fgColor, border, font, isOpaque, isEditable);
    }

    static {
        for (ParameterView.Mode mode : ParameterView.Mode.values()) {
            COMPONENT_PROPERTIES.put(mode, ComponentProperties.createComponentProperties(mode));
        }
    }
}

