/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.actions.CommonEditAction;
import csbase.client.applications.algorithmsmanager.dialogs.CategoryCreateDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CategorySelectionPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CategoryTreeView;
import csbase.client.applications.algorithmsmanager.dialogs.CommonSelectionPanel;
import csbase.client.applications.algorithmsmanager.models.CategoryNodeInterface;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.Category;
import javax.swing.ImageIcon;

public class CategoryCreateAction
extends CommonEditAction {
    private CategoryCreateDataPanel createPanel;
    private CategoryNodeInterface parentCategory;

    public CategoryCreateAction(CommonSelectionPanel selectionPanel, ImageIcon icon) {
        super(selectionPanel, icon);
    }

    @Override
    protected void handleEditOperation() {
        this.createPanel = new CategoryCreateDataPanel(this);
        this.parentCategory = (CategoryNodeInterface)this.getSelectionPanel().getSelectedData();
        this.getSelectionPanel().getManagementAction().setCreatePanel(this.createPanel);
        this.createPanel.initializeData();
    }

    public Category getParentCategory() {
        if (this.parentCategory != null) {
            return this.parentCategory.getNode();
        }
        return null;
    }

    protected String getParentCategoryId() {
        if (this.parentCategory != null) {
            return this.parentCategory.getId();
        }
        return null;
    }

    public String getParentCategoryName() {
        if (this.parentCategory == null) {
            return CategoryTreeView.ROOT_NAME;
        }
        return this.parentCategory.getFullName();
    }

    public Category createCategory(String categoryName) {
        Category category = AlgorithmManagementProxy.createCategory(this.getParentCategoryId(), categoryName, ((AlgorithmsManager)this.getApplication()).getApplicationFrame());
        return category;
    }

    public void cancelCreation() {
        this.getSelectionPanel().getManagementAction().setCreatePanel(null);
    }

    @Override
    public CategorySelectionPanel getSelectionPanel() {
        return (CategorySelectionPanel)super.getSelectionPanel();
    }
}

