/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger;

import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationProject;
import csbase.client.applications.fileexchanger.FileExchangerUI;
import csbase.client.applications.fileexchanger.actions.BlockSizeAction;
import csbase.client.applications.fileexchanger.actions.ClearEndedAction;
import csbase.client.applications.fileexchanger.actions.DeleteAction;
import csbase.client.applications.fileexchanger.actions.ExportAction;
import csbase.client.applications.fileexchanger.actions.ImportAction;
import csbase.client.applications.fileexchanger.actions.InterruptAction;
import csbase.client.applications.fileexchanger.actions.ShowErrorAction;
import csbase.client.applications.fileexchanger.actions.StartAction;
import csbase.client.applications.fileexchanger.actions.ToggleAdvancedColumnsVisibilityAction;
import csbase.client.applications.fileexchanger.actions.ToggleDetailVisibilityAction;
import csbase.client.applications.fileexchanger.actions.TransferModeAction;
import csbase.client.applications.fileexchanger.exceptions.InvalidFilesToExportException;
import csbase.client.applications.fileexchanger.exceptions.InvalidNameException;
import csbase.client.applications.fileexchanger.exceptions.InvalidReservedNameException;
import csbase.client.applications.fileexchanger.logic.BlockSize;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeExport;
import csbase.client.applications.fileexchanger.logic.ExchangeImport;
import csbase.client.applications.fileexchanger.logic.ExchangeMode;
import csbase.client.applications.fileexchanger.logic.ExchangeState;
import csbase.client.applications.fileexchanger.logic.FileExchangerConfiguration;
import csbase.client.applications.fileexchanger.panels.detailpanel.DetailPanel;
import csbase.client.applications.fileexchanger.panels.tablepanel.TableListPanel;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectDirectoryChooser;
import csbase.client.project.ProjectFileChooserOpen;
import csbase.client.project.ProjectTreePath;
import csbase.client.project.tasks.GetChildFromNameTask;
import csbase.client.project.tasks.GetChildrenTask;
import csbase.client.util.ClientUtilities;
import csbase.logic.ClientProjectFile;
import csbase.logic.NoHiddenFileFilter;
import csbase.logic.ProjectFileFilter;
import csbase.logic.ProjectFileType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public final class FileExchanger
extends ApplicationProject {
    private static final int OPTION_YES = 0;
    private static final int OPTION_YES_ALL = 1;
    private static final int OPTION_NO = 2;
    private static final int OPTION_NO_ALL = 3;
    private final Thread interfaceUpdateThread;
    private final Thread checkPendingExchangesThread;
    private long currenIntervalToCheckPendingTransfers = 3000L;
    private final List<Exchange> exchangeList = Collections.synchronizedList(new ArrayList());
    private final TableListPanel tablePanel;
    private final DetailPanel detailPanel;
    private final JSplitPane splitPane;
    private boolean advancedColumnsVisible = false;
    private final FileExchangerConfiguration configuration = new FileExchangerConfiguration(this);
    private final JFileChooser importationFileChooser = new JFileChooser();
    private static String exportationCurrentDirectory = new String();

    public final synchronized void addToExchangeList(Exchange exchange) {
        this.exchangeList.add(exchange);
        exchange.signalAdded();
    }

    public final synchronized void addExchangeErrorToExchangeList(Exchange exchange) {
        this.exchangeList.add(exchange);
        exchange.signalError();
    }

    private JMenu buildActionsMenu() {
        JMenu menu = new JMenu();
        menu.setText(this.getMenuString("actions"));
        menu.add(new ClearEndedAction(this));
        menu.addSeparator();
        menu.add(new ShowErrorAction(this));
        menu.add(new DeleteAction(this));
        menu.add(new StartAction(this));
        menu.add(new InterruptAction(this));
        return menu;
    }

    private JMenu buildAdvancedMenu() {
        JMenu menu = new JMenu();
        String menuText = this.getMenuString("advanced");
        menu.setText(menuText);
        ToggleDetailVisibilityAction detAction = new ToggleDetailVisibilityAction(this);
        JCheckBoxMenuItem detItem = new JCheckBoxMenuItem(detAction);
        menu.add(detItem);
        ToggleAdvancedColumnsVisibilityAction advAction = new ToggleAdvancedColumnsVisibilityAction(this);
        JCheckBoxMenuItem advItem = new JCheckBoxMenuItem(advAction);
        menu.add(advItem);
        menu.addSeparator();
        menu.add(this.buildTransferModeMenu());
        menu.add(this.buildBlockSizeMenu());
        return menu;
    }

    private JMenu buildBlockSizeMenu() {
        JMenu menu = new JMenu();
        menu.setText(this.getMenuString("advanced.block.size"));
        ButtonGroup grp = new ButtonGroup();
        for (BlockSize value : BlockSize.values()) {
            BlockSizeAction action = new BlockSizeAction(this, value);
            JRadioButtonMenuItem it = new JRadioButtonMenuItem(action);
            menu.add(it);
            grp.add(it);
            if (value != this.getConfiguration().getBlockSize()) continue;
            it.setSelected(true);
        }
        return menu;
    }

    private JMenu buildFileMenu() {
        JMenu menu = new JMenu();
        menu.setText(this.getMenuString("file"));
        menu.add(new ImportAction(this));
        menu.add(new ExportAction(this));
        menu.addSeparator();
        menu.add(new ApplicationExitAction(this));
        return menu;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.buildFileMenu());
        menuBar.add(this.buildActionsMenu());
        menuBar.add(this.buildAdvancedMenu());
        return menuBar;
    }

    private JToolBar buildToolBar() {
        String appName = this.getName();
        JToolBar toolBar = new JToolBar(appName);
        toolBar.setFloatable(false);
        toolBar.add(new ImportAction(this));
        toolBar.add(new ExportAction(this));
        toolBar.addSeparator();
        toolBar.add(new ClearEndedAction(this));
        toolBar.addSeparator();
        toolBar.add(new DeleteAction(this));
        toolBar.add(new StartAction(this));
        toolBar.add(new InterruptAction(this));
        toolBar.addSeparator();
        return toolBar;
    }

    private JMenu buildTransferModeMenu() {
        JMenu menu = new JMenu();
        menu.setText(this.getMenuString("advanced.transfer.mode"));
        ButtonGroup grp = new ButtonGroup();
        for (ExchangeMode tp : ExchangeMode.values()) {
            TransferModeAction action = new TransferModeAction(this, tp);
            JRadioButtonMenuItem it = new JRadioButtonMenuItem(action);
            menu.add(it);
            grp.add(it);
            if (tp != this.configuration.getTransferMode()) continue;
            it.setSelected(true);
        }
        return menu;
    }

    private Thread buildInterfaceUpdateThread() {
        Thread thread = new Thread(){

            @Override
            public final void run() {
                try {
                    while (true) {
                        long ms = FileExchanger.this.configuration.getGuiUpdateInterval();
                        Thread.sleep(ms);
                        FileExchanger.this.updateExchangePanel(false, false);
                        FileExchanger.this.markPointsOfRunningExchanges();
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        return thread;
    }

    private Thread buildCheckPendingExchangesThread() {
        Thread thread = new Thread(){

            @Override
            public final void run() {
                try {
                    while (true) {
                        FileExchanger.this.checkPending();
                        Thread.sleep(FileExchanger.this.currenIntervalToCheckPendingTransfers);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        return thread;
    }

    protected void markPointsOfRunningExchanges() {
        Exchange[] exchangeArray;
        for (Exchange e : exchangeArray = this.exchangeList.toArray(new Exchange[this.exchangeList.size()])) {
            if (e.getState() != ExchangeState.RUNNING) continue;
            e.ping();
        }
    }

    protected void checkPending() {
        Exchange[] exchangeArray;
        boolean thereIsPendingExchange = false;
        int running_threads = 0;
        for (Exchange e : exchangeArray = this.exchangeList.toArray(new Exchange[this.exchangeList.size()])) {
            if ((long)running_threads >= this.configuration.getMaxSimultaneousTransfers()) {
                thereIsPendingExchange = true;
                break;
            }
            if (e.getState() == ExchangeState.RUNNING) {
                ++running_threads;
                continue;
            }
            if (e.getState() != ExchangeState.QUEUED) continue;
            ++running_threads;
            e.start();
        }
        this.currenIntervalToCheckPendingTransfers = thereIsPendingExchange ? this.configuration.getMinIntervalToCheckPendingTransfers() : this.configuration.getMaxIntervalToCheckPendingTransfers();
    }

    public final synchronized void clearEndedExchanges() {
        ArrayList<Exchange> list = new ArrayList<Exchange>();
        for (Exchange e : this.exchangeList) {
            ExchangeState state = e.getState();
            if (state == ExchangeState.RUNNING || state == ExchangeState.QUEUED) continue;
            list.add(e);
        }
        for (Exchange e : list) {
            this.delFromExchangeList(e);
        }
        this.updateExchangePanel(true, false);
    }

    public final synchronized void delFromExchangeList(Exchange exchange) {
        this.exchangeList.remove(exchange);
        exchange.signalRemoved();
        this.updateExchangePanel(true, false);
    }

    public final int getNumShownColumns() {
        int n = 13;
        if (!this.isAdvancedColumnsVisible()) {
            return 11;
        }
        return 13;
    }

    private void doUpdate(boolean structureChanged) {
        this.tablePanel.updateTable(structureChanged);
        this.detailPanel.updateData(this.getSelectedExchangeList());
    }

    private final void exportFileToLocalDirectory(ClientProjectFile remoteFile, File localDir, String localName) {
        File localFile = new File(localName = localName != null && !localName.isEmpty() ? localDir.getAbsolutePath() + File.separator + localName : localDir.getAbsolutePath() + File.separator + remoteFile.getName());
        if (localFile.exists()) {
            ApplicationFrame frame = this.getApplicationFrame();
            String title = FileExchangerUI.getString("FileExchanger.export.title");
            Object[] args = new String[]{localName, localDir.getName()};
            String tag = "export.overwrite.msg";
            String msg = FileExchangerUI.getClassString(this.getClass(), "export.overwrite.msg", args);
            int option = StandardDialogs.showYesNoDialog((Component)frame, (String)title, (Object)msg);
            if (option == 1) {
                return;
            }
        }
        this.transferFile(remoteFile, localFile);
    }

    public final void exportFilesToLocalDirectory(List<ClientProjectFile> remoteFiles, File localDir) {
        ApplicationFrame frame = this.getApplicationFrame();
        int option = 0;
        for (ClientProjectFile remoteFile : remoteFiles) {
            String localName = localDir.getAbsolutePath() + File.separator + remoteFile.getName();
            File localFile = new File(localName);
            boolean shouldTranferFile = true;
            if (localFile.exists()) {
                Object[] args = new String[]{localName, localDir.getName()};
                String tag = "FileExchanger.export.overwrite.msg";
                if (remoteFile.isDirectory()) {
                    tag = "FileExchanger.export.overwrite_directory.msg";
                }
                String msg = FileExchangerUI.getString(tag, args);
                String title = FileExchangerUI.getString("FileExchanger.export.title");
                if (remoteFiles.size() == 1) {
                    int singleFileOption = StandardDialogs.showYesNoDialog((Component)frame, (String)title, (Object)msg);
                    if (singleFileOption == 1) {
                        shouldTranferFile = false;
                    }
                } else {
                    if (option != 1 && option != 3) {
                        Object[] options = new Object[]{LNG.get((String)"UTIL_YES"), LNG.get((String)"UTIL_YES_TO_ALL"), LNG.get((String)"UTIL_NO"), LNG.get((String)"UTIL_NO_TO_ALL")};
                        option = StandardDialogs.showOptionDialog((Component)frame, (String)title, (Object)msg, (Object[])options);
                    }
                    if (option == 2 || option == 3) {
                        shouldTranferFile = false;
                    }
                }
            }
            if (!shouldTranferFile) continue;
            this.transferFile(remoteFile, localFile);
        }
    }

    public final void exportToDirectory(List<ClientProjectFile> remoteFiles, Boolean wasRunning) throws Exception {
        ApplicationFrame frame = this.getApplicationFrame();
        if (remoteFiles != null) {
            try {
                this.isValidFilesToExport(remoteFiles);
            }
            catch (InvalidFilesToExportException e) {
                String title = FileExchangerUI.getString("FileExchanger.export.title");
                StandardDialogs.showErrorDialog((Component)frame, (String)title, (String)e.getMessage());
                if (wasRunning != null && !wasRunning.booleanValue()) {
                    this.closeApplication();
                }
                return;
            }
        }
        boolean exportMultipleFiles = this.configuration.isExportMultipleFiles();
        boolean exportDirectories = this.configuration.isExportDirectories();
        int mode = 0;
        mode = exportDirectories ? 2 : 0;
        if (remoteFiles == null) {
            ProjectFileChooserOpen chooser;
            remoteFiles = new Vector<ClientProjectFile>();
            if (exportMultipleFiles) {
                chooser = null;
                chooser = new ProjectFileChooserOpen(frame, DesktopFrame.getInstance().getProject(), exportMultipleFiles, mode);
                ProjectTreePath[] projectTreePaths = chooser.getSelectedPaths();
                if (projectTreePaths == null) {
                    return;
                }
                for (ProjectTreePath projectTreePath : projectTreePaths) {
                    remoteFiles.add(projectTreePath.getFile());
                }
            } else {
                chooser = null;
                chooser = new ProjectFileChooserOpen(frame, DesktopFrame.getInstance().getProject(), exportMultipleFiles, mode);
                ProjectTreePath projectTreePath = chooser.getSelectedPath();
                if (projectTreePath == null) {
                    return;
                }
                remoteFiles.add(projectTreePath.getFile());
            }
        }
        JFileChooser exportationFileChooser = new JFileChooser();
        exportationFileChooser.setMultiSelectionEnabled(false);
        exportationFileChooser.setDialogTitle(FileExchangerUI.getString("FileExchanger.export.title"));
        exportationFileChooser.setApproveButtonText(FileExchangerUI.getString("FileExchanger.export.filechooser.approvebuttontext"));
        exportationFileChooser.setApproveButtonToolTipText(FileExchangerUI.getString("FileExchanger.export.filechooser.approvebuttontooltiptext"));
        exportationFileChooser.setCurrentDirectory(new File(exportationCurrentDirectory));
        int result = 1;
        if (remoteFiles.size() == 1 && !remoteFiles.get(0).isDirectory()) {
            ClientProjectFile file = remoteFiles.get(0);
            exportationFileChooser.setSelectedFile(new File(file.getName()));
            exportationFileChooser.setFileSelectionMode(0);
            result = exportationFileChooser.showDialog(frame, FileExchangerUI.getString("FileExchanger.export.filechooser.approvebuttontext"));
        } else {
            exportationFileChooser.setFileSelectionMode(1);
            result = exportationFileChooser.showOpenDialog(frame);
        }
        String localName = null;
        File localDir = null;
        if (result == 1) {
            if (wasRunning != null && !wasRunning.booleanValue()) {
                this.closeApplication();
            }
            return;
        }
        if (result == 0) {
            if (remoteFiles.size() == 1 && !remoteFiles.get(0).isDirectory()) {
                localName = exportationFileChooser.getSelectedFile().getName();
                if (localName != null) {
                    localDir = exportationFileChooser.getSelectedFile().getParentFile();
                }
            } else {
                localDir = exportationFileChooser.getSelectedFile();
            }
        }
        if (localDir == null || !localDir.exists()) {
            String title = FileExchangerUI.getString("FileExchanger.export.title");
            Object[] args = new String[]{localDir.getName()};
            String err = "FileExchanger.invalid.directory.error";
            String msg = FileExchangerUI.getString("FileExchanger.invalid.directory.error", args);
            DesktopFrame dsk = DesktopFrame.getInstance();
            StandardDialogs.showErrorDialog((Component)dsk.getDesktopFrame(), (String)title, (String)msg);
        }
        exportationCurrentDirectory = localDir.getAbsolutePath();
        if (remoteFiles.size() == 1) {
            this.exportFileToLocalDirectory(remoteFiles.get(0), localDir, localName);
        } else {
            this.exportFilesToLocalDirectory(remoteFiles, localDir);
        }
    }

    public void isValidFilesToExport(List<ClientProjectFile> remoteFiles) throws InvalidFilesToExportException {
        boolean exportMultipleFiles = this.configuration.isExportMultipleFiles();
        boolean exportDirectories = this.configuration.isExportDirectories();
        int mode = 0;
        mode = exportDirectories ? 2 : 0;
        if (!exportMultipleFiles) {
            if (remoteFiles.size() > 1) {
                if (mode == 0) {
                    String msg = FileExchangerUI.getString("FileExchanger.export.file_only");
                    throw new InvalidFilesToExportException(msg);
                }
                String msg = FileExchangerUI.getString("FileExchanger.export.file_or_directory");
                throw new InvalidFilesToExportException(msg);
            }
            if (mode == 0) {
                for (ClientProjectFile remoteFile : remoteFiles) {
                    if (!remoteFile.isDirectory()) continue;
                    String msg = FileExchangerUI.getString("FileExchanger.export.file_only");
                    throw new InvalidFilesToExportException(msg);
                }
            }
        }
        if (mode == 0) {
            for (ClientProjectFile remoteFile : remoteFiles) {
                if (!remoteFile.isDirectory()) continue;
                String msg = FileExchangerUI.getString("FileExchanger.export.files_only");
                throw new InvalidFilesToExportException(msg);
            }
        }
    }

    public final FileExchangerConfiguration getConfiguration() {
        return this.configuration;
    }

    public final synchronized Exchange getExchangeItem(int index) {
        if (index < 0 || index >= this.exchangeList.size()) {
            return null;
        }
        return this.exchangeList.get(index);
    }

    public final synchronized List<Exchange> getExchangeList(ExchangeState state) {
        if (state == null) {
            return this.exchangeList;
        }
        ArrayList<Exchange> list = new ArrayList<Exchange>();
        for (Exchange e : this.exchangeList) {
            if (e.getState() != state) continue;
            list.add(e);
        }
        return list;
    }

    public final synchronized int getExchangeListSize() {
        return this.exchangeList.size();
    }

    private final String getMenuString(String tag) {
        return FileExchangerUI.getString("FileExchanger." + tag + ".menu");
    }

    public final synchronized ArrayList<Exchange> getSelectedExchangeList() {
        int[] sels = this.tablePanel.getSelectedIndexes();
        ArrayList<Exchange> list = new ArrayList<Exchange>();
        for (int sel : sels) {
            list.add(this.exchangeList.get(sel));
        }
        return list;
    }

    private final void importFileToDirectory(File localFile, ClientProjectFile remoteDir) throws Exception {
        String localFileName = localFile.getName();
        if (localFileName.matches("^..*csbase$") || localFileName.matches("^..*csbase_description$")) {
            this.addInvalidFiles(localFile, remoteDir, new InvalidReservedNameException(localFileName));
            return;
        }
        if (!ClientUtilities.isValidFileName(localFileName)) {
            this.addInvalidFiles(localFile, remoteDir, new InvalidNameException());
            return;
        }
        ClientProjectFile remoteFile = GetChildFromNameTask.runTask(remoteDir, localFileName);
        ApplicationFrame frame = this.getApplicationFrame();
        if (remoteFile != null) {
            Object[] args = new String[]{localFileName, remoteDir.getName()};
            String tag = "FileExchanger.import.overwrite.msg";
            if (remoteFile.isDirectory()) {
                tag = "FileExchanger.import.overwrite_directory.msg";
            }
            String msg = FileExchangerUI.getString(tag, args);
            String title = FileExchangerUI.getString("FileExchanger.import.title");
            int option = StandardDialogs.showYesNoDialog((Component)frame, (String)title, (Object)msg);
            if (option == 1) {
                return;
            }
        }
        this.transferFile(localFile, remoteFile, remoteDir);
    }

    private final void importFileToDirectory(ArrayList<File> localFileList, ClientProjectFile remoteDir) throws Exception {
        ClientProjectFile[] children = GetChildrenTask.runTask(remoteDir);
        int option = 0;
        for (File localFile : localFileList) {
            String fileName = localFile.getName();
            ClientProjectFile remoteFile = null;
            if (!ClientUtilities.isValidFileName(fileName)) {
                this.addInvalidFiles(localFile, remoteDir, new InvalidNameException());
                continue;
            }
            if (fileName.matches("^..*csbase$") || fileName.matches("^..*csbase_description$")) {
                this.addInvalidFiles(localFile, remoteDir, new InvalidReservedNameException(fileName));
                continue;
            }
            ApplicationFrame frame = this.getApplicationFrame();
            boolean shouldTranferFile = true;
            for (int i = 0; i < children.length && remoteFile == null; ++i) {
                ClientProjectFile child = children[i];
                if (!fileName.equals(child.getName())) continue;
                remoteFile = child;
                if (option != 1 && option != 3) {
                    Object[] args = new String[]{fileName, remoteDir.getName()};
                    String tag = "FileExchanger.import.overwrite.msg";
                    if (remoteFile.isDirectory()) {
                        tag = "FileExchanger.import.overwrite_directory.msg";
                    }
                    String msg = FileExchangerUI.getString(tag, args);
                    String title = FileExchangerUI.getString("FileExchanger.import.title");
                    Object[] options = new Object[]{LNG.get((String)"UTIL_YES"), LNG.get((String)"UTIL_YES_TO_ALL"), LNG.get((String)"UTIL_NO"), LNG.get((String)"UTIL_NO_TO_ALL")};
                    option = StandardDialogs.showOptionDialog((Component)frame, (String)title, (Object)msg, (Object[])options);
                }
                if (option != 2 && option != 3) continue;
                shouldTranferFile = false;
            }
            if (!shouldTranferFile) continue;
            this.transferFile(localFile, remoteFile, remoteDir);
        }
    }

    public final void importToDirectory(ClientProjectFile remoteDir, Boolean wasRunning) throws Exception {
        boolean importMultipleFiles;
        ApplicationFrame frame = this.getApplicationFrame();
        this.importationFileChooser.setDialogType(0);
        boolean importDirectories = this.configuration.isImportDirectories();
        if (importDirectories) {
            this.importationFileChooser.setFileSelectionMode(2);
        }
        if (importMultipleFiles = this.configuration.isImportMultipleFiles()) {
            this.importationFileChooser.setMultiSelectionEnabled(true);
            int ret = this.importationFileChooser.showOpenDialog(frame);
            if (ret == 1) {
                if (wasRunning != null && !wasRunning.booleanValue()) {
                    this.closeApplication();
                }
                return;
            }
            File[] localFiles = this.importationFileChooser.getSelectedFiles();
            if (localFiles == null || localFiles.length == 0) {
                String title = FileExchangerUI.getString("FileExchanger.import.title");
                String err = this.getString("FileExchanger.invalid.selection.error");
                DesktopFrame dsk = DesktopFrame.getInstance();
                StandardDialogs.showErrorDialog((Component)dsk.getDesktopFrame(), (String)title, (String)err);
                return;
            }
            if (remoteDir == null) {
                ProjectDirectoryChooser chooser = null;
                chooser = new ProjectDirectoryChooser(DesktopFrame.getInstance().getProject(), frame);
                ProjectTreePath projectTreePath = chooser.getSelectedDirectory();
                if (projectTreePath == null) {
                    return;
                }
                remoteDir = projectTreePath.getFile();
            }
            ArrayList<File> localFileList = new ArrayList<File>();
            for (File localFile : localFiles) {
                localFileList.add(localFile);
            }
            if (localFileList.size() == 1) {
                this.importFileToDirectory((File)localFileList.get(0), remoteDir);
            } else {
                this.importFileToDirectory(localFileList, remoteDir);
            }
        } else {
            this.importationFileChooser.setMultiSelectionEnabled(false);
            int ret = this.importationFileChooser.showOpenDialog(frame);
            File localFile = null;
            if (ret == 1) {
                if (wasRunning != null && !wasRunning.booleanValue()) {
                    this.closeApplication();
                }
                return;
            }
            localFile = this.importationFileChooser.getSelectedFile();
            if (localFile == null || !localFile.exists()) {
                String title = FileExchangerUI.getString("FileExchanger.import.title");
                String err = FileExchangerUI.getString("FileExchanger.import.invalid.file.error");
                StandardDialogs.showErrorDialog((Component)frame, (String)title, (String)err);
                return;
            }
            if (remoteDir == null) {
                if (localFile.isDirectory()) {
                    ProjectDirectoryChooser chooser = null;
                    chooser = new ProjectDirectoryChooser(DesktopFrame.getInstance().getProject(), frame);
                    ProjectTreePath projectTreePath = chooser.getSelectedDirectory();
                    if (projectTreePath == null) {
                        return;
                    }
                    remoteDir = projectTreePath.getFile();
                } else {
                    String localFileName = localFile.getName();
                    String localFileExtension = FileUtils.getFileExtension((String)localFileName);
                    ProjectFileType pft = ProjectFileType.getProjectFileTypeFromExtension((String)localFileExtension, (boolean)false);
                    String fileType = pft == null ? "" : pft.getCode();
                    ClientProjectFile remoteFile = this.browseFileSave(fileType, localFileExtension, localFileName, frame);
                    if (remoteFile == null) {
                        return;
                    }
                    remoteDir = remoteFile.getParent();
                    this.transferFile(localFile, remoteFile, remoteDir);
                    return;
                }
            }
            this.importFileToDirectory(localFile, remoteDir);
        }
    }

    public final boolean isDetailVisible() {
        return this.detailPanel.isVisible();
    }

    public final boolean isAdvancedColumnsVisible() {
        return this.advancedColumnsVisible;
    }

    public final void setAdvancedColumnsVisible(boolean visible) {
        this.advancedColumnsVisible = visible;
        this.updateExchangePanel(true, true);
    }

    @Override
    public final void killApplication() {
        this.interfaceUpdateThread.interrupt();
        this.checkPendingExchangesThread.interrupt();
    }

    public final void selectionChanged() {
        this.detailPanel.updateData(this.getSelectedExchangeList());
    }

    public void setDetailVisible(boolean visible) {
        this.detailPanel.setVisible(visible);
        this.splitPane.setOneTouchExpandable(visible);
        double divider = 0.5;
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setDividerLocation(0.5);
    }

    public final void transferFile(ClientProjectFile sourceFile, File targetFile) {
        boolean showHiddenFiles;
        NoHiddenFileFilter filter = null;
        if (sourceFile.isDirectory() && !(showHiddenFiles = DesktopFrame.getInstance().shouldShowHiddenFiles())) {
            filter = NoHiddenFileFilter.getInstance();
        }
        ExchangeExport exchange = new ExchangeExport(this.configuration.getTransferMode(), this.configuration.getBlockSize(), targetFile, sourceFile, this.getApplicationProject(), (ProjectFileFilter)filter);
        this.treatExchange(exchange);
    }

    public final void transferFile(File sourceFile, ClientProjectFile targetFile, ClientProjectFile remoteDir) {
        ExchangeImport exchange = new ExchangeImport(this.configuration.getTransferMode(), this.configuration.getBlockSize(), sourceFile, targetFile, remoteDir, this.getApplicationProject());
        this.treatExchange(exchange);
    }

    private final void addInvalidFiles(File invalidFile, ClientProjectFile remoteDir, Exception exception) {
        ExchangeImport exchange = new ExchangeImport(this.configuration.getTransferMode(), this.configuration.getBlockSize(), invalidFile, null, remoteDir, this.getApplicationProject());
        exchange.signalEnded(exception);
        this.treatInvalidExchange(exchange);
    }

    private void treatExchange(Exchange exchange) {
        this.addToExchangeList(exchange);
        this.updateExchangePanel(true, false);
        ApplicationFrame frame = this.getApplicationFrame();
        frame.toFront();
        frame.setState(0);
    }

    private void treatInvalidExchange(Exchange exchange) {
        this.addExchangeErrorToExchangeList(exchange);
        this.updateExchangePanel(true, false);
        ApplicationFrame frame = this.getApplicationFrame();
        frame.toFront();
        frame.setState(0);
    }

    private void updateExchangePanel(boolean isOnSwing, final boolean structureChanged) {
        if (isOnSwing) {
            this.doUpdate(structureChanged);
        } else {
            SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                @Override
                public final void run() {
                    FileExchanger.this.doUpdate(structureChanged);
                }
            });
        }
    }

    @Override
    protected boolean userCanKillApplication() {
        List<Exchange> running = this.getExchangeList(ExchangeState.RUNNING);
        List<Exchange> queued = this.getExchangeList(ExchangeState.QUEUED);
        int size = running.size() + queued.size();
        if (size > 0) {
            Object[] args = new String[]{String.valueOf(size)};
            String msg = FileExchangerUI.getString("FileExchanger.close.transmissionsInProgress", args);
            String title = this.getName();
            ApplicationFrame frame = this.getApplicationFrame();
            int option = StandardDialogs.showYesNoDialog((Component)frame, (String)title, (Object)msg);
            if (option == 1) {
                return false;
            }
            this.interruptTransmissions(running);
            this.interruptTransmissions(queued);
        }
        return true;
    }

    private void interruptTransmissions(List<Exchange> list) {
        for (Exchange exchange : list) {
            exchange.interrupt();
        }
    }

    public FileExchanger(String id) {
        super(id);
        this.tablePanel = new TableListPanel(this);
        this.detailPanel = new DetailPanel(this);
        this.detailPanel.setVisible(false);
        ApplicationFrame frame = this.getApplicationFrame();
        JMenuBar menuBar = this.buildMenuBar();
        frame.setJMenuBar(menuBar);
        this.splitPane = new JSplitPane(0);
        this.splitPane.add(this.tablePanel);
        this.splitPane.add(this.detailPanel);
        this.splitPane.setOneTouchExpandable(false);
        Container panel = frame.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.buildToolBar(), "North");
        panel.add((Component)this.splitPane, "Center");
        frame.setSize(new Dimension(700, 400));
        this.interfaceUpdateThread = this.buildInterfaceUpdateThread();
        this.interfaceUpdateThread.start();
        this.checkPendingExchangesThread = this.buildCheckPendingExchangesThread();
        this.checkPendingExchangesThread.start();
    }
}

