/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.ClientServerManager;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.ClientRemoteMonitorListener;
import csbase.logic.LoginInfo;
import csbase.logic.MonitoredServerListener;
import csbase.logic.ServerURI;
import csbase.logic.server.ServerInfo;
import csbase.remote.ServerServiceInterface;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.table.SortableTable;

public final class ServerStatusFrame
extends DesktopComponentFrame {
    private ServerTableModel serverTableModel = new ServerTableModel();
    private JCheckBox usePasswordCheckBox;
    private MonitoredServerListener monitoredServerListener = new ClientRemoteMonitorListener(this);
    private static ServerStatusFrame frame;
    private JTextField jtfUser;
    private JPasswordField jtfPassword;
    private JCheckBox cloneServerSessionCheckBox;

    private ServerStatusFrame(JFrame owner) {
        super("Servidores conectados");
        ServerStatusListener l = new ServerStatusListener();
        ClientServerManager.getInstance().addCommonListener(l);
        this.buildGui();
    }

    public static void show(JFrame owner) {
        if (frame == null) {
            frame = new ServerStatusFrame(owner);
        }
        frame.setLocationRelativeTo(owner);
        frame.setVisible(true);
    }

    private JPanel buildMainPanel() {
        SortableTable table = new SortableTable((TableModel)this.serverTableModel);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        panel.add((Component)new JScrollPane((Component)table), gbc);
        gbc.gridwidth = 1;
        final JComboBox<Object> jcbServers = new JComboBox<Object>();
        RemoteTask<SortedSet<ServerInfo>> t = new RemoteTask<SortedSet<ServerInfo>>(){

            protected void performTask() throws Exception {
                SortedSet serversInfos = ((ServerServiceInterface)ClientServerManager.getInstance().getService(ServerServiceInterface.class)).getServersInfos();
                this.setResult(serversInfos);
            }
        };
        if (t.execute(this, "Inicializando", "Consultando servidor..")) {
            SortedSet servers = (SortedSet)t.getResult();
            for (ServerInfo ts : servers) {
                if (ts.isSuspended()) continue;
                jcbServers.addItem(ts.getURI());
            }
        }
        JButton btnConnectServer = new JButton("Conectar");
        if (jcbServers.getItemCount() == 0) {
            jcbServers.addItem("Nenhum servidor foi encontrado.");
            jcbServers.setEnabled(false);
            btnConnectServer.setEnabled(false);
        } else {
            btnConnectServer.setEnabled(true);
        }
        btnConnectServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                boolean usePassword = ServerStatusFrame.this.usePasswordCheckBox.isSelected();
                ServerURI sURI = (ServerURI)jcbServers.getSelectedItem();
                boolean copySession = ServerStatusFrame.this.cloneServerSessionCheckBox.isSelected();
                if (!usePassword) {
                    ServerStatusFrame.this.loginByReference(sURI, copySession);
                } else {
                    ServerStatusFrame.this.loginWithUserAndPassword(sURI);
                }
                ServerStatusFrame.this.serverTableModel.loadData();
            }
        });
        this.jtfUser = new JTextField();
        this.jtfPassword = new JPasswordField();
        this.usePasswordCheckBox = new JCheckBox("Usar usu\u00e1rio e senha");
        this.usePasswordCheckBox.setSelected(true);
        this.cloneServerSessionCheckBox = new JCheckBox("Copiar sess\u00e3o do servidor default (somente p/ login por refer\u00eancia)");
        this.usePasswordCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean b = ServerStatusFrame.this.usePasswordCheckBox.isSelected();
                ServerStatusFrame.this.jtfUser.setEnabled(b);
                ServerStatusFrame.this.jtfPassword.setEnabled(b);
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        panel.add((Component)this.cloneServerSessionCheckBox, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 2;
        panel.add((Component)this.usePasswordCheckBox, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        panel.add(jcbServers, gbc);
        gbc.gridx = 2;
        gbc.gridy = 2;
        panel.add((Component)btnConnectServer, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        panel.add((Component)new JLabel("Usu\u00e1rio:"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        panel.add((Component)this.jtfUser, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        panel.add((Component)new JLabel("Senha:"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        panel.add((Component)this.jtfPassword, gbc);
        return panel;
    }

    protected JPanel buildButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        JButton closeButton = new JButton("Fechar");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                frame.setVisible(false);
            }
        });
        panel.add(closeButton);
        return panel;
    }

    private void buildGui() {
        this.getContentPane().add((Component)this.buildMainPanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonsPanel(), "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setResizable(false);
    }

    private final void login(final ServerURI sURI) {
        RemoteTask<Boolean> t = new RemoteTask<Boolean>(sURI){

            @Override
            protected void handleError(Exception error) {
                StandardDialogs.showErrorDialog((Component)ServerStatusFrame.this, (String)"Erro", (String)error.getMessage());
            }

            protected void performTask() throws Exception {
                this.setResult(ClientServerManager.getInstance().login(sURI));
            }
        };
        if (t.execute(this, "Login", "Contactando servidor..") && !((Boolean)t.getResult()).booleanValue()) {
            StandardDialogs.showErrorDialog((Component)this, (String)"Erro", (String)"Login ou senha inv\u00e1lidos.");
        }
    }

    private final void loginByReference(final ServerURI sURI, final boolean copySession) {
        String errTitle = "Erro";
        String errMessage = "Login ou senha inv\u00e1lidos";
        RemoteTask<Boolean> t = new RemoteTask<Boolean>(){

            @Override
            protected void handleError(Exception error) {
                StandardDialogs.showErrorDialog((Component)ServerStatusFrame.this, (String)"Erro", (String)error.getMessage());
            }

            protected void performTask() throws Exception {
                this.setResult(ClientServerManager.getInstance().loginByReference(sURI, copySession));
            }
        };
        if (t.execute(this, "Login", "Contactando servidor..") && !((Boolean)t.getResult()).booleanValue()) {
            StandardDialogs.showErrorDialog((Component)this, (String)"Erro", (String)"Login ou senha inv\u00e1lidos");
        }
    }

    private final void loginWithUserAndPassword(final ServerURI sURI) {
        String user = this.jtfUser.getText();
        String pass = new String(this.jtfPassword.getPassword());
        if (user == null || user.length() == 0 || pass.length() == 0) {
            StandardDialogs.showErrorDialog((Component)this, (String)"Erro", (String)"Usu\u00e1rio e senha s\u00e3o obrigat\u00f3rios");
        } else {
            final LoginInfo loginInfo = new LoginInfo(user, pass, Locale.getDefault());
            RemoteTask<Boolean> t = new RemoteTask<Boolean>(){

                @Override
                protected void handleError(Exception error) {
                    StandardDialogs.showErrorDialog((Component)ServerStatusFrame.this, (String)"Erro", (String)error.getMessage());
                }

                protected void performTask() throws Exception {
                    this.setResult(ClientServerManager.getInstance().loginWithUserPassword(sURI, loginInfo));
                }
            };
            if (t.execute(this, "Login", "Contactando servidor..")) {
                if (!((Boolean)t.getResult()).booleanValue()) {
                    StandardDialogs.showErrorDialog((Component)this, (String)"Erro", (String)"Login ou senha inv\u00e1lidos");
                } else {
                    this.serverTableModel.loadData();
                }
            }
        }
    }

    private final void logout(final ServerURI sURI) {
        new RemoteTask<Void>(sURI){

            protected void performTask() {
                ClientServerManager.getInstance().logout(sURI, false);
            }
        }.execute(this, "Logout", "Contactando servidor..");
    }

    private class ServerStatusListener
    implements MonitoredServerListener {
        private ServerStatusListener() {
        }

        public void notifyConnectionLost(ServerURI serverURI) {
            ServerStatusFrame.this.serverTableModel.loadData();
        }

        public void notifyConnectionReestablished(ServerURI serverURI) {
            ServerStatusFrame.this.serverTableModel.loadData();
        }

        public void notifyLoggedIn(ServerURI serverURI) {
            ServerStatusFrame.this.serverTableModel.loadData();
        }

        public void notifyLoggedOut(ServerURI serverURI) {
            ServerStatusFrame.this.serverTableModel.loadData();
        }
    }

    private final class ServerTableModel
    extends AbstractTableModel {
        String[] headers = new String[]{"URI", "Conectado?", "Padr\u00e3o?"};
        Object[][] values;

        public ServerTableModel() {
            this.loadData();
        }

        @Override
        public int getColumnCount() {
            return this.values[0].length;
        }

        @Override
        public int getRowCount() {
            return this.values.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.values[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                if (!((Boolean)this.values[rowIndex][columnIndex]).booleanValue()) {
                    ClientServerManager.getInstance().setDefaultServer((ServerURI)this.values[rowIndex][0]);
                    this.loadData();
                }
            } else if (columnIndex == 1 && !((Boolean)this.values[rowIndex][2]).booleanValue()) {
                ServerURI sURI = (ServerURI)this.values[rowIndex][0];
                if (((Boolean)value).booleanValue()) {
                    ServerStatusFrame.this.login(sURI);
                } else {
                    ServerStatusFrame.this.logout(sURI);
                }
                this.loadData();
            }
        }

        @Override
        public String getColumnName(int column) {
            return this.headers[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2 || columnIndex == 1;
        }

        protected void loadData() {
            Set availableServers = ClientServerManager.getInstance().getManagedServers();
            this.values = new Object[availableServers.size()][this.headers.length];
            int c = 0;
            for (ServerURI sURI : availableServers) {
                this.values[c][0] = sURI;
                this.values[c][1] = ClientServerManager.getInstance().isAlive(sURI);
                this.values[c++][2] = ClientServerManager.getInstance().isDefault(sURI);
            }
            this.fireTableDataChanged();
        }
    }
}

