/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.RoleProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.Role;
import csbase.logic.User;
import csbase.logic.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class UserRoleDefinitionDialog {
    private UserInfo userInfo;
    private DesktopComponentDialog ownerDialog;
    private DesktopComponentDialog mainDialog;
    private String dialogTitle;
    private ContainerSelection<Role> rolesSelection;

    private Vector<Role> getUserRoles() {
        Object[] roleIds = (Object[])this.userInfo.getAttribute("roleIds");
        if (roleIds == null) {
            return new Vector<Role>();
        }
        Vector<Role> roles = new Vector<Role>(roleIds.length);
        try {
            for (int i = 0; i < roleIds.length; ++i) {
                roles.add(i, Role.getRole((Object)roleIds[i]));
            }
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this.mainDialog, this.dialogTitle, LNG.get((String)"IAS_USER_ROLES_RETRIEVAL_ERROR"));
        }
        return roles;
    }

    public void showDialog() {
        this.dialogTitle = LNG.get((String)"IAS_USER_ROLES_TITLE");
        this.mainDialog = new DesktopComponentDialog((Window)this.ownerDialog, this.dialogTitle);
        Vector<Role> roles = RoleProxy.getAllRoles(this.mainDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_ALL_ROLES"));
        if (roles == null) {
            StandardErrorDialogs.showErrorDialog((Window)this.mainDialog, this.dialogTitle, LNG.get((String)"IAS_USER_ROLES_RETRIEVAL_ERROR"));
            return;
        }
        Container cp = this.mainDialog.getContentPane();
        JPanel selectionPanel = this.createSelectionPanel(roles, this.getUserRoles());
        cp.add((Component)selectionPanel, "Center");
        JButton confirmButton = new JButton(LNG.get((String)"IAS_CONFIRM"));
        confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserRoleDefinitionDialog.this.updateUserRoles();
                UserRoleDefinitionDialog.this.mainDialog.close();
            }
        });
        JButton cancelButton = new JButton(LNG.get((String)"IAS_CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserRoleDefinitionDialog.this.mainDialog.close();
            }
        });
        ClientUtilities.adjustEqualSizes(confirmButton, cancelButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(confirmButton);
        buttonsPanel.add(cancelButton);
        cp.add((Component)buttonsPanel, "South");
        this.mainDialog.pack();
        this.mainDialog.center(this.ownerDialog);
        this.mainDialog.setVisible(true);
    }

    private JPanel createSelectionPanel(Vector<Role> selectableRoles, Vector<Role> userRoles) {
        DefaultObjectTableProvider selectableFormat = new DefaultObjectTableProvider(){

            public String[] getColumnNames() {
                return new String[]{LNG.get((String)"IAS_AVAILABLE_ROLES")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{String.class};
            }

            public Object[] getCellValues(Object arg0) {
                String[] stringArray;
                Role role = (Role)arg0;
                if (role == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = role.getName();
                }
                return stringArray;
            }
        };
        DefaultObjectTableProvider selectedFormat = new DefaultObjectTableProvider(){

            public String[] getColumnNames() {
                return new String[]{LNG.get((String)"IAS_SELECTED_ROLES")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{String.class};
            }

            public Object[] getCellValues(Object arg0) {
                String[] stringArray;
                Role role = (Role)arg0;
                if (role == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = role.getName();
                }
                return stringArray;
            }
        };
        this.rolesSelection = new ContainerSelection((ObjectTableProvider)selectableFormat, (ObjectTableProvider)selectedFormat, true, false);
        this.rolesSelection.loadItems(selectableRoles, userRoles);
        this.rolesSelection.adjustTableColumns();
        return this.rolesSelection.getPanel();
    }

    void updateUserRoles() {
        if (this.rolesSelection == null) {
            this.userInfo.setAttribute("roleIds", (Object)new Object[0]);
            return;
        }
        List roles = this.rolesSelection.getSelectedItems();
        Object[] roleIds = new Object[roles.size()];
        for (int i = 0; i < roles.size(); ++i) {
            roleIds[i] = ((Role)roles.get(i)).getId();
        }
        this.userInfo.setAttribute("roleIds", (Object)roleIds);
    }

    public void clearSelected() {
        if (this.rolesSelection != null) {
            this.rolesSelection.clearSelectedItems();
        }
        this.updateUserRoles();
    }

    public UserRoleDefinitionDialog(DesktopComponentDialog ownerDialog, UserInfo userInfo, User user, boolean isNew) {
        this.ownerDialog = ownerDialog;
        this.userInfo = userInfo;
        if (user == null && !isNew) {
            throw new IllegalArgumentException("user == null");
        }
        if (!isNew) {
            this.userInfo.setAttribute("roleIds", user.getAttribute("roleIds"));
        }
    }

    public UserRoleDefinitionDialog(DesktopComponentDialog ownerDialog, UserInfo userInfo, boolean isNew) {
        this(ownerDialog, userInfo, null, isNew);
    }
}

