/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectFileChooser;
import csbase.client.project.ProjectTreePath;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;
import csbase.logic.filters.ProjectFileCompositeAndFilter;
import csbase.logic.filters.ProjectFileDirectoryFilter;
import csbase.logic.filters.ProjectFileNameFilter;
import csbase.logic.filters.ProjectFileNotFilter;
import csbase.logic.filters.ProjectFileTrueFilter;
import csbase.logic.filters.ProjectFileTypeFilter;
import java.awt.Window;
import tecgraf.javautils.core.lng.LNG;

public class ProjectFileChooserOpen
extends ProjectFileChooser {
    public ProjectFileChooserOpen(Window owner, CommonClientProject project, boolean isMultiSelectionEnabled, int mode) throws ClientException {
        this(owner, project, isMultiSelectionEnabled, mode, null);
    }

    public ProjectFileChooserOpen(Window owner, CommonClientProject project, boolean isMultiSelectionEnabled, int mode, String fileType) throws ClientException {
        this(owner, project, isMultiSelectionEnabled, mode, fileType, false);
    }

    public ProjectFileChooserOpen(Window owner, CommonClientProject project, boolean isMultiSelectionEnabled, int mode, String fileType, boolean useFilter) throws ClientException {
        this(owner, project, isMultiSelectionEnabled, mode, new String[]{fileType}, fileType, useFilter);
    }

    public ProjectFileChooserOpen(Window owner, CommonClientProject project, boolean isMultiSelectionEnabled, String[] fileTypes, String defaultType) throws ClientException {
        this(owner, project, isMultiSelectionEnabled, 0, fileTypes, defaultType);
    }

    public ProjectFileChooserOpen(Window owner, CommonClientProject project, boolean isMultiSelectionEnabled, int mode, String[] fileTypes, String defaultType) throws ClientException {
        this(owner, project, isMultiSelectionEnabled, mode, fileTypes, defaultType, false);
    }

    public ProjectFileChooserOpen(Window owner, CommonClientProject project, boolean isMultiSelectionEnabled, int mode, String[] fileTypes, String defaultType, boolean useFilter) throws ClientException {
        super(owner, LNG.get((String)"PRJ_FILE_CHOOSER_OPEN_TITLE"), project, isMultiSelectionEnabled, mode, defaultType, ProjectFileChooserOpen.createVisualFilter(mode, false, null, fileTypes), ProjectFileChooserOpen.createSelectionFilter(mode, null, fileTypes), false, null, useFilter);
        String title = this.getTitle();
        if (title != null) {
            this.dialog.setTitle(title);
        }
        this.dialog.setVisible(true);
    }

    @Override
    protected ProjectFileFilter getSelectionFilter() {
        return this.getSelectionFilter(null);
    }

    @Override
    protected ProjectFileFilter getSelectionFilter(String fileType) {
        return this.getSelectionFilter(null, fileType);
    }

    @Override
    protected ProjectFileFilter getSelectionFilter(String nameFilter, String fileType) {
        return ProjectFileChooserOpen.createSelectionFilter(this.mode, nameFilter, new String[]{fileType});
    }

    private static ProjectFileFilter createSelectionFilter(int mode, String name, String[] fileTypes) {
        boolean useNameFilter = name != null && !name.isEmpty();
        boolean useTypeFilter = fileTypes != null && fileTypes.length != 0;
        ProjectFileCompositeAndFilter andFilter = new ProjectFileCompositeAndFilter();
        if (useNameFilter) {
            andFilter.addChild((ProjectFileFilter)new ProjectFileNameFilter(name));
        }
        if (useTypeFilter) {
            andFilter.addChild((ProjectFileFilter)new ProjectFileTypeFilter(fileTypes));
        }
        switch (mode) {
            case 0: {
                andFilter.addChild((ProjectFileFilter)new ProjectFileNotFilter((ProjectFileFilter)ProjectFileDirectoryFilter.getInstance()));
                break;
            }
            case 1: {
                andFilter.addChild((ProjectFileFilter)ProjectFileDirectoryFilter.getInstance());
                break;
            }
            case 2: {
                andFilter.addChild((ProjectFileFilter)ProjectFileTrueFilter.getInstance());
                break;
            }
            default: {
                String msg = String.format("Modo inv\u00e1lido %s.", mode);
                throw new IllegalArgumentException(msg);
            }
        }
        return andFilter;
    }

    @Override
    protected boolean handleAction() {
        ClientProjectFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles != null) {
            this.selectedPaths = new ProjectTreePath[selectedFiles.length];
            for (int i = 0; i < this.selectedPaths.length; ++i) {
                this.selectedPaths[i] = new ProjectTreePath(selectedFiles[i]);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void makeSelection(ClientProjectFile[] projectFileArray) {
        if (projectFileArray.length == 0) {
            this.selectedPaths = null;
            this.fileNameText.setText("");
        } else {
            this.selectedPaths = new ProjectTreePath[projectFileArray.length];
            String newText = "";
            String separator = "";
            for (int i = 0; i < projectFileArray.length; ++i) {
                this.selectedPaths[i] = new ProjectTreePath(projectFileArray[i]);
                newText = newText + separator + projectFileArray[i].getName();
                separator = ",";
            }
            this.fileNameText.setText(newText);
        }
    }
}

