/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import java.util.logging.Level;
import java.util.logging.LogRecord;

public class CodeBlockLog {
    private static final String BEGIN_LOG_MESSAGE = "[Thread:%s][BEGIN] %s";
    private static final String FINISHED_LOG_MESSAGE = "[Thread:%s][FINISHED:%.3fs] %s";
    private Level level;
    private String message;
    private long begin;

    public CodeBlockLog(Level level, String messageTemplate, Object ... args) {
        this.level = level;
        this.message = String.format(messageTemplate, args);
    }

    public LogRecord begin() {
        this.begin = System.currentTimeMillis();
        return new LogRecord(this.level, String.format(BEGIN_LOG_MESSAGE, Thread.currentThread().getName(), this.message));
    }

    public LogRecord finished() {
        return new LogRecord(this.level, String.format(FINISHED_LOG_MESSAGE, Thread.currentThread().getName(), (double)(System.currentTimeMillis() - this.begin) * 1.0 / 1000.0, this.message));
    }
}

