/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.algorithms.tasks.OutdatedFlowTask;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.actions.AlgorithmsManagerAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmSelectionPanel;
import csbase.client.applications.algorithmsmanager.dialogs.OutdatedFlowDialog;
import csbase.client.desktop.DesktopFrame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class ListOutdatedAlgorithmAction
extends AlgorithmsManagerAction {
    private AlgorithmSelectionPanel selectionPanel;
    private OutdatedFlowDialog dialog;

    public ListOutdatedAlgorithmAction(AlgorithmsManager app, AlgorithmSelectionPanel selectionPanel) {
        super(app, (ImageIcon)null);
        this.selectionPanel = selectionPanel;
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        this.doAction();
    }

    private void doAction() {
        String resultTitle = this.getClassString("updating.flows", new Object[0]);
        OutdatedFlowTask task = new OutdatedFlowTask();
        ApplicationFrame window = ((AlgorithmsManager)this.getApplication()).getApplicationFrame();
        String title = DesktopFrame.getInstance().getTitle();
        String message = this.getClassString("searching.outdated.flow", new Object[0]);
        try {
            task.execute(window, title, message);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(window, this.getClassString("error.searching.flows", new Object[0]), resultTitle, -1);
            return;
        }
        Vector result = (Vector)task.getResult();
        if (result.size() <= 0) {
            JOptionPane.showMessageDialog(window, this.getClassString("all.updated", new Object[0]), resultTitle, -1);
        } else {
            if (this.dialog == null) {
                this.dialog = new OutdatedFlowDialog(result, this.getSelectionPanel());
            } else {
                this.dialog.setData(result, this.getSelectionPanel());
            }
            this.dialog.setVisible(true);
        }
    }

    public AlgorithmSelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    public void setSelectionPanel(AlgorithmSelectionPanel selectionPanel) {
        this.selectionPanel = selectionPanel;
        if (this.dialog != null) {
            this.dialog.setSelectionPanel(selectionPanel);
        }
    }

    public void updateToReload() {
        if (this.dialog != null && this.dialog.isVisible()) {
            this.doAction();
        }
    }
}

