/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class RubberBand {
    private static final Color COLOR = new Color(63, 178, 255);
    private static final Stroke STROKE = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{4.0f, 3.0f}, 4.0f);
    private Point2D endPoint;
    private Point2D startPoint;

    public RubberBand(Point2D startPoint) {
        this.endPoint = this.startPoint = (Point2D)startPoint.clone();
    }

    public Rectangle2D getBounds() {
        Rectangle bounds = new Rectangle();
        bounds.setFrameFromDiagonal(this.startPoint, this.endPoint);
        return bounds;
    }

    public void paint(Graphics2D g) {
        g.setColor(COLOR);
        g.setStroke(STROKE);
        Rectangle2D rectangle = this.getBounds();
        GeneralPath path = new GeneralPath();
        path.moveTo((float)rectangle.getMinX(), (float)rectangle.getMinY());
        path.lineTo((float)rectangle.getMinX(), (float)rectangle.getMaxY());
        path.lineTo((float)rectangle.getMaxX(), (float)rectangle.getMaxY());
        path.lineTo((float)rectangle.getMaxX(), (float)rectangle.getMinY());
        path.closePath();
        g.draw(path);
    }

    public void setPoint(Point2D endPoint) {
        this.endPoint = (Point2D)endPoint.clone();
    }
}

