/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager;

import csbase.client.applications.projectsmanager.AbstractProjectsManagerObserver;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectPermissions;
import csbase.logic.SharedProjectEvent;
import csbase.logic.User;
import java.util.Observable;
import tecgraf.javautils.gui.SwingThreadDispatcher;

class ProjectSharingStatusObserver
extends AbstractProjectsManagerObserver {
    ProjectSharingStatusObserver(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == null) {
            return;
        }
        if (!(arg instanceof SharedProjectEvent)) {
            return;
        }
        final SharedProjectEvent event = (SharedProjectEvent)arg;
        final CommonProjectInfo cpi = event.getProjectInfo();
        final ProjectsManagerData pmd = this.projectsManager.getProject(cpi);
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectPermissions.SharingType newSharingType = event.getSharingType();
                if (pmd == null) {
                    if (newSharingType != ProjectPermissions.SharingType.PRIVATE) {
                        ProjectSharingStatusObserver.this.addProject(cpi);
                    }
                    return;
                }
                User user = ProjectsManager.getUser();
                Object currentUserID = user.getId();
                if (!user.isAdmin() && ProjectSharingStatusObserver.this.userLostAccess(currentUserID, newSharingType, cpi)) {
                    ProjectSharingStatusObserver.this.projectsManager.removeProject(cpi);
                } else if (!ProjectSharingStatusObserver.this.setSharingStatusInfo(pmd, event)) {
                    return;
                }
                ProjectSharingStatusObserver.this.projectsManager.refreshProjectsTable();
            }
        });
    }

    private boolean userLostAccess(Object currentUserID, ProjectPermissions.SharingType newSharingType, CommonProjectInfo cpi) {
        if (currentUserID.equals(cpi.userId)) {
            return false;
        }
        return newSharingType == ProjectPermissions.SharingType.PRIVATE || newSharingType == ProjectPermissions.SharingType.PARTIAL && !ProjectPermissions.userHasSelectiveAccess((CommonProjectInfo)cpi, (Object)currentUserID);
    }

    private boolean setSharingStatusInfo(ProjectsManagerData pmd, SharedProjectEvent event) {
        ProjectPermissions.SharingType st = event.getSharingType();
        boolean ret = pmd.setSharingType(st);
        if (!ret && st != ProjectPermissions.SharingType.PARTIAL) {
            return false;
        }
        if (event.getSharingType() == ProjectPermissions.SharingType.PARTIAL) {
            pmd.setUsers(event.getUsersRO(), event.getUsersRW());
        }
        return true;
    }
}

