/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.serverdiagnostic.monitor;

import csbase.client.applications.serverdiagnostic.ServerDiagnostic;
import csbase.client.applications.serverdiagnostic.monitor.DefaultSwingRenderer;
import csbase.client.applications.serverdiagnostic.monitor.StatusGroupTreeNode;
import csbase.client.applications.serverdiagnostic.monitor.StatusNode;
import csbase.client.applications.serverdiagnostic.monitor.StatusTree;
import csbase.client.applications.serverdiagnostic.monitor.SwingRenderer;
import csbase.logic.diagnosticservice.Status;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class StatusListPanel
extends JPanel {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private ServerDiagnostic application;
    private SwingRenderer defaultRenderer;
    private JSplitPane splitPane;
    private JPanel headlinePanel;
    private JPanel detailPanel;
    private StatusGroupTreeNode node;

    public StatusListPanel(ServerDiagnostic application, StatusGroupTreeNode node) {
        this.node = node;
        this.application = application;
        this.defaultRenderer = new DefaultSwingRenderer();
        this.buildPanel();
    }

    private void buildPanel() {
        this.headlinePanel = new JPanel(new BorderLayout());
        this.detailPanel = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane(1, this.headlinePanel, this.detailPanel);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(200);
        Dimension minimumSize = new Dimension(200, 50);
        this.headlinePanel.setMinimumSize(minimumSize);
        this.detailPanel.setMinimumSize(minimumSize);
        this.detailPanel.add(Box.createRigidArea(new Dimension(450, 450)));
        this.setLayout(new BorderLayout());
        this.add(this.splitPane);
    }

    private void updateDetailPanel(JPanel panel) {
        this.detailPanel.removeAll();
        this.detailPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        constraints.anchor = 11;
        constraints.insets = new Insets(0, 5, 0, 0);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.detailPanel.add((Component)panel, constraints);
        this.revalidate();
        this.repaint();
    }

    public void setDefaultRenderer(SwingRenderer renderer) {
        this.defaultRenderer = renderer;
    }

    public void refreshPanel() {
        this.headlinePanel.removeAll();
        this.headlinePanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        constraints.anchor = 11;
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.headlinePanel.add((Component)new JScrollPane(this.createStatusTree()), constraints);
        this.revalidate();
        this.repaint();
    }

    private JTree createStatusTree() {
        StatusTree statusTree = new StatusTree(this.application.getLocale(), this.node);
        statusTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                JTree tree = (JTree)treeSelectionEvent.getSource();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (node != null && node.isLeaf()) {
                    JPanel panel;
                    StatusNode selectedNodeData = (StatusNode)node.getUserObject();
                    if (selectedNodeData.name == null) {
                        Status selectStatus = selectedNodeData.status;
                        SwingRenderer renderer = selectedNodeData.renderer;
                        if (renderer == null) {
                            renderer = StatusListPanel.this.defaultRenderer;
                        }
                        panel = (JPanel)renderer.getDetails(selectStatus);
                    } else {
                        panel = new JPanel();
                        panel.setLayout(new BoxLayout(panel, 3));
                        Status status = selectedNodeData.status;
                        SwingRenderer renderer = selectedNodeData.renderer;
                        if (renderer == null) {
                            renderer = StatusListPanel.this.defaultRenderer;
                        }
                        panel.add(renderer.getDetails(status));
                    }
                    StatusListPanel.this.updateDetailPanel(panel);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(statusTree);
        return statusTree;
    }
}

