/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.sgamonitor;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationComponentDialog;
import csbase.client.applications.sgamonitor.SGAMonitor;
import csbase.client.applications.sgamonitor.SGAMonitorPref;
import csbase.client.applications.sgamonitor.filters.NameFilter;
import csbase.client.facilities.configurabletable.UI.UI4Tables;
import csbase.client.facilities.configurabletable.UIFactory;
import csbase.client.facilities.configurabletable.stringprovider.ApplicationStringProvider;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import csbase.client.facilities.configurabletable.table.RowToKey;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.types.PVTables;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class ClusterMonitor
extends ApplicationComponentDialog<SGAMonitor>
implements Observer {
    private static final String CLUSTER_PANEL = "cluster-panel";
    private UI4Tables ui4Tables;
    private JTextField searchField;
    private String clusterName;

    public ClusterMonitor(SGAMonitor app) {
        super(app);
        ApplicationStringProvider stringProvider = new ApplicationStringProvider((Application)this.getApplication());
        UIFactory uiFactory = new UIFactory(app.getConfig(), stringProvider);
        this.ui4Tables = uiFactory.getUI4Tables(CLUSTER_PANEL);
        this.buildInterface();
        this.pack();
    }

    @Override
    public void setVisible(boolean visible) {
        PreferenceCategory appPrefs = ((SGAMonitor)this.getApplication()).getPreferences();
        PVTables pv = (PVTables)appPrefs.getPreference(SGAMonitorPref.CLUSTER_TABLES);
        if (visible) {
            pv.loadTables(this.ui4Tables.getAllTables());
        } else {
            pv.storeTables(this.ui4Tables.getAllTables());
            ((SGAMonitor)this.getApplication()).savePreferences();
        }
        super.setVisible(visible);
    }

    public void updateClusterInfo(SGASet cluster) {
        ArrayList<SGAInfo> sgasInfo = new ArrayList<SGAInfo>();
        for (SGAInfo info : cluster.getAllInfo()) {
            sgasInfo.add(info);
        }
        this.clusterName = cluster.getName();
        Object app = this.getApplication();
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable((Application)app, sgasInfo){
            final /* synthetic */ Application val$app;
            final /* synthetic */ List val$sgasInfo;
            {
                this.val$app = application;
                this.val$sgasInfo = list;
            }

            @Override
            public void run() {
                ClusterMonitor.this.setTitle(String.format(this.val$app.getString("cluster.monitor"), ClusterMonitor.this.clusterName));
                for (ConfigurableTable<SGAInfo> table : ClusterMonitor.this.ui4Tables.getAllTables(SGAInfo.class)) {
                    table.updateRows(this.val$sgasInfo);
                }
            }
        });
    }

    @Override
    public void update(Observable o, Object arg) {
        List sgaSetList = (List)arg;
        for (SGASet sgaSet : sgaSetList) {
            if (!sgaSet.getName().equals(this.clusterName)) continue;
            final ArrayList<SGAInfo> sgaInfoList = new ArrayList<SGAInfo>();
            for (SGAInfo info : sgaSet.getAllInfo()) {
                sgaInfoList.add(info);
            }
            SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (ConfigurableTable<SGAInfo> table : ClusterMonitor.this.ui4Tables.getAllTables(SGAInfo.class)) {
                        table.updateRows(sgaInfoList);
                    }
                }
            });
        }
    }

    private void buildInterface() {
        this.setJMenuBar(this.createMenuBar());
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        JLabel searchLabel = new JLabel(((SGAMonitor)this.getApplication()).getString("search.label"));
        this.searchField = new JTextField();
        this.searchField.getDocument().addDocumentListener(new FilterNameListener(this));
        JPanel searchPanel = new JPanel(new GridBagLayout());
        searchPanel.add((Component)searchLabel, new GBC(0, 0).west().top(15).left(10));
        searchPanel.add((Component)this.searchField, new GBC(1, 0).top(15).left(10).right(50).horizontal());
        for (ConfigurableTable<SGAInfo> table : this.ui4Tables.getAllTables(SGAInfo.class)) {
            table.setFilter(new NameFilter());
            table.setRowToKey(new RowToKey<SGAInfo>(){

                @Override
                public String getKey(SGAInfo row) {
                    return row.getHostName();
                }
            });
        }
        container.add((Component)searchPanel, new GBC(0, 0).west().left(10).bottom(0).horizontal());
        container.add((Component)((Object)this.ui4Tables), new GBC(0, 1).both().insets(10, 10, 10, 10));
        JButton close = new JButton(((SGAMonitor)this.getApplication()).getString("button.close"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClusterMonitor.this.setVisible(false);
            }
        });
        container.add((Component)close, new GBC(0, 2).none().east().insets(0, 0, 10, 20));
    }

    private JMenuBar createMenuBar() {
        JMenu menu = new JMenu(((SGAMonitor)this.getApplication()).getString("menu.tables"));
        for (ConfigurableTable<?> table : this.ui4Tables.getAllTables()) {
            JMenu subMenu = new JMenu(this.ui4Tables.getTableLabel(table.getId()));
            for (JCheckBoxMenuItem item : table.createColumnsCheckBoxes()) {
                subMenu.add(item);
            }
            menu.add(subMenu);
        }
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        return menuBar;
    }

    private void updateNameFilter() {
        try {
            String regex = this.searchField.getText();
            Pattern newPattern = Pattern.compile(regex);
            for (ConfigurableTable<SGAInfo> table : this.ui4Tables.getAllTables(SGAInfo.class)) {
                NameFilter filter = (NameFilter)table.getFilter();
                filter.setPattern(newPattern);
                table.updateRows();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    private class FilterNameListener
    implements DocumentListener {
        private ClusterMonitor clusterMonitor;

        public FilterNameListener(ClusterMonitor clusterMonitor2) {
            this.clusterMonitor = clusterMonitor2;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.clusterMonitor.updateNameFilter();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }
    }
}

