/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.desktop.CloneTask;
import csbase.client.desktop.DesktopAction;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.externalresources.ExternalResources;
import java.awt.event.ActionEvent;

public class CloneDesktopAction
extends DesktopAction<DesktopFrame> {
    @Override
    public void actionPerformed(ActionEvent e) {
        this.cloneDesktop();
    }

    protected boolean cloneDesktop() {
        String message;
        String title;
        ExternalResources extResources = ExternalResources.getInstance();
        if (!extResources.isEnabled()) {
            this.showErrorMessage("no.external.resources.error");
            return false;
        }
        CloneTask task = new CloneTask(this);
        Object desktop = this.getDesktop();
        DesktopComponentFrame frame = ((DesktopFrame)desktop).getDesktopFrame();
        boolean executed = task.execute(frame, title = frame.getTitle(), message = this.getString("clone.task.message"));
        if (!executed) {
            String causeText = "";
            Exception exception = task.getError();
            if (exception != null) {
                causeText = exception.getMessage();
            }
            String tag = "clone.launch.error";
            String err = this.getString("clone.launch.error", causeText);
            this.showErrorMessage(err);
            return false;
        }
        return true;
    }

    public CloneDesktopAction() {
        super(DesktopFrame.getInstance());
        ExternalResources extResources = ExternalResources.getInstance();
        this.setEnabled(extResources.isEnabled());
    }
}

