/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.types;

import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.editors.PVDimensionEditor;
import csbase.client.preferences.util.PreferenceBundle;
import java.awt.Dimension;

public class PVDimension
extends PreferenceValue<Dimension> {
    public PVDimension(PreferenceDefinition name, String value, String defaultValue, PreferencePolicy policy, PreferenceBundle preferenceBundle) {
        super(name, value, defaultValue, policy, preferenceBundle);
        this.setPreferenceEditorClass(PVDimensionEditor.class);
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String toString() {
        return ((Dimension)this.getValue()).width + "," + ((Dimension)this.getValue()).height;
    }

    @Override
    public Dimension toValue(String value) {
        String[] split = value.split(" *, *");
        int width = Integer.parseInt(split[0]);
        int height = Integer.parseInt(split[1]);
        return new Dimension(width, height);
    }

    @Override
    public PreferenceValue<Dimension> clone() {
        return new PVDimension(this.name, this.toString(), this.defaultValue, this.policy, this.preferenceBundle);
    }
}

