/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.desktop.RemoteTask;
import csbase.client.externalresources.ExternalResources;
import csbase.client.externalresources.LocalFile;
import csbase.client.project.ExportTask;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonProjectAction;
import csbase.client.remote.srvproxies.NotificationProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.CSBaseException;
import csbase.logic.ClientProjectFile;
import csbase.logic.User;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public abstract class CommonFileExportAction
extends CommonProjectAction {
    protected static final String JNLP_CANT_EXPORT_DIR = "JNLP_CANT_EXPORT_DIR";
    protected static final String ACTION_NAME = "PRJ_EXPORT_FILE";
    protected static final String CRITICAL_ERROR = "PRJ_PROJECT_FILE_IMPORT_CRITICAL_ERROR";
    protected static final String SINGLE_FILE_ERROR = "EXPORT_SINGLE_FILE_ERROR";
    protected static final String FILE_EXISTS = "PRJ_PROJECT_FILE_EXPORT_FILE_EXISTS";
    protected static final String EMPTY_FILE = "PRJ_PROJECT_FILE_EXPORT_EMPTY_FILE";
    protected static final String EXPORT_IN_PROGRESS_MSG = "PRJ_PROJECT_FILE_EXPORT_IN_PROGRESS";
    protected static final String SUCCESS = "PRJ_PROJECT_FILE_EXPORT_SUCCESS";
    protected static final String SUCCESS_JNLP = "PRJ_PROJECT_FILE_EXPORT_SUCCESS_JNLP";
    protected static final String TITLE = "PRJ_PROJECT_FILE_EXPORT_TITLE";
    protected static final String UPDATE_FILE = "PRJ_PROJECT_FILE_UPDATE_FILE";

    public CommonFileExportAction(ProjectFileContainer container) {
        super(container);
    }

    @Override
    protected void showError(String msg) {
        this.showError(LNG.get((String)TITLE), msg);
    }

    protected void showError(String msg, Exception ex) {
        StandardErrorDialogs.showErrorDialog(this.getWindow(), LNG.get((String)TITLE), msg, ex);
    }

    protected double getTotalSizeInKBytes(long sizeInBytes) {
        return sizeInBytes / 1024L;
    }

    protected double getElapsedTime(long start) {
        return (double)(System.currentTimeMillis() - start) / 1000.0;
    }

    protected double getTransferRate(double totalSize, double elapsedTime) {
        return totalSize / elapsedTime;
    }

    protected Collection<ClientProjectFile> selectTopFiles(ClientProjectFile[] selectedFiles) {
        ArrayList<ClientProjectFile> topFiles = new ArrayList<ClientProjectFile>();
        block0: for (int i = 0; i < selectedFiles.length; ++i) {
            for (int j = 0; j < selectedFiles.length; ++j) {
                if (i != j && this.isDescendantOf(selectedFiles[i], selectedFiles[j])) continue block0;
            }
            topFiles.add(selectedFiles[i]);
        }
        return topFiles;
    }

    protected boolean isDescendantOf(ClientProjectFile descendant, ClientProjectFile ancestor) {
        String[] ancPath;
        String[] descPath = descendant.getPath();
        if (descPath.length <= (ancPath = ancestor.getPath()).length) {
            return false;
        }
        for (int i = 0; i < ancPath.length; ++i) {
            if (descPath[i].equals(ancPath[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean confirmOverwrite(File targetFile) {
        String msg = MessageFormat.format(LNG.get((String)FILE_EXISTS), targetFile.getAbsolutePath());
        int answer = StandardDialogs.showYesNoDialog((Component)this.getWindow(), (String)LNG.get((String)TITLE), (Object)msg);
        return answer == 0;
    }

    @Override
    public String getName() {
        return LNG.get((String)ACTION_NAME);
    }

    protected boolean confirmEmptyFileExport(ClientProjectFile sourceFile) {
        String msg = MessageFormat.format(LNG.get((String)EMPTY_FILE), sourceFile.getStringPath());
        int answer = StandardDialogs.showYesNoDialog((Component)this.getWindow(), (String)LNG.get((String)TITLE), (Object)msg);
        return answer == 0;
    }

    protected long getFileSize(final ClientProjectFile sourceFile) {
        RemoteTask<Void> checkTask = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                sourceFile.updateInfo();
            }
        };
        if (!checkTask.execute(this.getWindow(), LNG.get((String)TITLE), LNG.get((String)UPDATE_FILE))) {
            return -1L;
        }
        return sourceFile.size();
    }

    protected boolean transferFile(ClientProjectFile sourceFile, File targetFile) {
        long startTime = System.currentTimeMillis();
        ExportTask exportTask = new ExportTask(targetFile, sourceFile, this.getWindow());
        String msg = MessageFormat.format(LNG.get((String)EXPORT_IN_PROGRESS_MSG), targetFile.getName());
        if (exportTask.execute(this.getWindow(), LNG.get((String)TITLE), msg, false, true)) {
            double transferSize = this.getTotalSizeInKBytes(exportTask.getTotalSize());
            double elapsedTime = this.getElapsedTime(startTime);
            double transferRate = this.getTransferRate(transferSize, elapsedTime);
            msg = MessageFormat.format(LNG.get((String)SUCCESS), sourceFile.getName(), FormatUtils.formatNumber((double)transferSize, (int)1), FormatUtils.formatNumber((double)elapsedTime, (int)1), FormatUtils.formatNumber((double)transferRate, (int)1));
            Object[] ids = new Object[]{User.getLoggedUser().getId()};
            NotificationProxy.notifyTo(ids, msg, false, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean transferFileUsingJNLP(ClientProjectFile selectedFile) {
        if (!ExternalResources.getInstance().isEnabled()) {
            this.showError(LNG.get((String)CRITICAL_ERROR));
            return false;
        }
        if (selectedFile.isDirectory()) {
            this.showError(LNG.get((String)JNLP_CANT_EXPORT_DIR));
            return false;
        }
        InputStream projectFileInputStream = null;
        try {
            projectFileInputStream = selectedFile.getInputStream();
            LocalFile transferredFile = ExternalResources.getInstance().saveFileDialog(null, null, projectFileInputStream, selectedFile.getName());
            if (transferredFile != null) {
                double transferSize = this.getTotalSizeInKBytes(selectedFile.size());
                String msg = MessageFormat.format(LNG.get((String)SUCCESS_JNLP), selectedFile.getName(), FormatUtils.formatNumber((double)transferSize, (int)1));
                Object[] ids = new Object[]{User.getLoggedUser().getId()};
                NotificationProxy.notifyTo(ids, msg, false, false);
            }
            boolean bl = true;
            return bl;
        }
        catch (CSBaseException ex3) {
            this.showError(LNG.get((String)SINGLE_FILE_ERROR), (Exception)((Object)ex3));
        }
        catch (IOException ex4) {
            this.showError(LNG.get((String)SINGLE_FILE_ERROR), ex4);
        }
        finally {
            try {
                if (projectFileInputStream != null) {
                    projectFileInputStream.close();
                }
            }
            catch (IOException ex5) {
                ex5.printStackTrace();
            }
        }
        return false;
    }
}

