/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.table;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MultiHeaderTableModel
implements TableModel {
    private TableModel model;
    private int numHeaderRows;

    public MultiHeaderTableModel(TableModel model, int numHeaderRows) {
        this.model = model;
        this.numHeaderRows = numHeaderRows;
    }

    @Override
    public int getRowCount() {
        return this.model.getRowCount() - this.numHeaderRows;
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<html><center>");
        for (int i = 0; i < this.numHeaderRows; ++i) {
            Object value = this.model.getValueAt(i, columnIndex);
            if (value != null) {
                builder.append(value);
            }
            builder.append("<br>");
        }
        builder.append("</center></html>");
        return builder.toString();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.model.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.model.isCellEditable(rowIndex + this.numHeaderRows, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.getValueAt(rowIndex + this.numHeaderRows, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.model.setValueAt(aValue, rowIndex + this.numHeaderRows, columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.model.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.model.removeTableModelListener(l);
    }
}

