/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class GenericCellEditor
extends DefaultCellEditor {
    private Constructor<?> constructor;
    private Object value;
    private JTable table;
    private int column;
    private int row;

    public GenericCellEditor(JTextField textField) {
        super(textField);
        this.getComponent().setName("Table.editor");
    }

    public GenericCellEditor() {
        this(new JTextField());
    }

    public GenericCellEditor setHorizontalAlignment(int alignment) {
        ((JTextField)this.getComponent()).setHorizontalAlignment(alignment);
        return this;
    }

    public void clearInvalidValueWarning() {
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
    }

    public void warnInvalidValue(Exception e) {
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
    }

    @Override
    public boolean stopCellEditing() {
        String s = (String)super.getCellEditorValue();
        if (s.trim().isEmpty()) {
            if (this.constructor.getDeclaringClass() == String.class) {
                this.value = "";
            }
            super.stopCellEditing();
            return true;
        }
        try {
            this.value = this.valueOf(s, this.table, this.row, this.column);
        }
        catch (Exception e) {
            this.warnInvalidValue(e);
            return false;
        }
        if (super.stopCellEditing()) {
            this.clearInvalidValueWarning();
            return true;
        }
        return false;
    }

    @Override
    public void cancelCellEditing() {
        this.clearInvalidValueWarning();
        super.cancelCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        this.table = table;
        this.column = column;
        this.row = row;
        try {
            Class<Object> type = table.getColumnClass(column);
            if (type == Object.class) {
                type = String.class;
            }
            this.constructor = type.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    protected Object valueOf(String stringValue, JTable table, int row, int column) throws Exception {
        return this.constructor.newInstance(stringValue);
    }
}

