/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.client.util.table.Validator;

public final class IntegerValidator
implements Validator {
    private Integer maximum;
    private Integer minimum;

    public IntegerValidator(Integer minimum, Integer maximum) {
        if (maximum == null) {
            maximum = Integer.MAX_VALUE;
        }
        if (minimum == null) {
            minimum = Integer.MIN_VALUE;
        }
        if (maximum.compareTo(minimum) < 0) {
            throw new IllegalArgumentException(String.format("O m\u00e1ximo %d \u00e9 menor do que o m\u00ednimo %d.", maximum, minimum));
        }
        this.maximum = maximum;
        this.minimum = minimum;
    }

    @Override
    public String getValidationErrorMessage(Object value) {
        Integer integerValue = (Integer)value;
        if (integerValue == null) {
            return null;
        }
        if (integerValue.compareTo(this.minimum) < 0) {
            return String.format("Valor abaixo do m\u00ednimo (%d).", this.minimum);
        }
        if (integerValue.compareTo(this.maximum) > 0) {
            return String.format("Valor acima do m\u00e1ximo (%d).", this.maximum);
        }
        return null;
    }
}

