/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.AbstractSimpleApplicationPanel;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.DataPropertiesListener;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.applications.algorithmsmanager.versiontree.PropertiesPanel;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTreeNode;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.ClientUtilities;
import csbase.logic.algorithms.AlgorithmProperty;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.GBC;

public class VersionPanel
extends AbstractSimpleApplicationPanel<AlgorithmsManager> {
    private List<AlgorithmProperty> versionProperties;
    private PropertiesPanel propertiesPanel;
    private JTextField versionField;
    protected AlgorithmListItem algoItem;
    private List<DataPropertiesListener> versionListeners;

    public VersionPanel(AlgorithmsManager application, AlgorithmListItem algoItem) {
        super(application);
        this.algoItem = algoItem;
        this.versionListeners = new Vector<DataPropertiesListener>();
        this.buildPanel();
    }

    @Override
    protected void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        JPanel mainInfoPanel = this.getMainInfoPanel();
        this.propertiesPanel = this.getVersionPropertiesPanel();
        this.add((Component)mainInfoPanel, new GBC(0, 0).horizontal().west().insets(0, 0, 0, 0));
        if (this.versionProperties.size() > 0) {
            this.add((Component)this.propertiesPanel.getPropertiesPanel(), new GBC(0, 1).horizontal().west().insets(0, 0, 0, 0));
        }
    }

    protected void notifyListeners(boolean wasModified) {
        for (DataPropertiesListener versionListener : this.versionListeners) {
            versionListener.propertiesChanged(wasModified);
        }
    }

    public void addVersionListener(DataPropertiesListener listener) {
        this.versionListeners.add(listener);
    }

    private PropertiesPanel getVersionPropertiesPanel() {
        this.versionProperties = AlgorithmManagementProxy.getAlgorithmVersionProperties(this.getWindow());
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new PropertiesPanel(this.versionProperties, new Hashtable<String, String>(), ((AlgorithmsManager)this.getApplication()).getString("VersionPanel.label.properties"), this.getWindow(), true);
            this.propertiesPanel.addPropertiesListener(wasModified -> this.notifyListeners(wasModified));
        }
        return this.propertiesPanel;
    }

    private JPanel getMainInfoPanel() {
        JPanel mainInfoPanel = new JPanel(new GridBagLayout());
        JLabel versionLabel = new JLabel(((AlgorithmsManager)this.getApplication()).getString("VersionPanel.label.version_id"));
        this.versionField = new JTextField(11);
        this.versionField.setEditable(false);
        this.versionField.setBorder(null);
        mainInfoPanel.add(versionLabel);
        mainInfoPanel.add((Component)versionLabel, new GBC(0, 0).none().west().insets(5, 5, 5, 5));
        mainInfoPanel.add((Component)this.versionField, new GBC(1, 0).none().west().insets(5, 5, 5, 5));
        mainInfoPanel.add(this.buildEmptyPanel(), new GBC(2, 0).both().insets(5, 5, 5, 5));
        return mainInfoPanel;
    }

    private Component buildEmptyPanel() {
        return new JPanel();
    }

    private Window getWindow() {
        return ((AlgorithmsManager)this.getApplication()).getApplicationFrame();
    }

    public int validateVersionNumberField(JTextField field, String errMsg) {
        try {
            int value = Integer.parseInt(field.getText());
            if (value >= 0 && value <= 999) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ClientUtilities.showErrorByTextField(((AlgorithmsManager)this.getApplication()).getApplicationFrame(), errMsg, null, field);
        return -1;
    }

    public Hashtable<String, String> getProperties() {
        return this.propertiesPanel.getProperties();
    }

    public boolean validateProperties() {
        return this.propertiesPanel.validateProperties();
    }

    public void initialize(AlgorithmListItem algoItem, VersionTreeNode versionNode) {
        this.algoItem = algoItem;
        AlgorithmVersionInfo version = null;
        if (versionNode != null) {
            version = (AlgorithmVersionInfo)versionNode.getUserObject();
            this.enablePropertiesEdition(true);
        } else {
            this.enableEdition(false);
        }
        String versionValue = versionNode != null ? String.valueOf(version.toString()) : "";
        Hashtable<String, String> properties = versionNode != null ? (Hashtable)version.getPropertyValues() : new Hashtable<String, String>();
        this.versionField.setText(versionValue);
        this.propertiesPanel.initializeFields(properties);
    }

    public void enableEdition(boolean state) {
        this.enablePropertiesEdition(state);
    }

    public void enablePropertiesEdition(boolean state) {
        this.propertiesPanel.enableEdition(state);
    }

    public boolean wasModified() {
        return this.propertiesPanel.wasModified();
    }
}

