/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ComponentProperties;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.client.applications.ApplicationImages;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.client.util.ClientUtilities;
import csbase.logic.SGASet;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.URLListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public abstract class URLListParameterView
extends SimpleParameterView<List<FileURLValue>> {
    protected static final String LNGPREFIX = URLListParameterView.class.getSimpleName() + ".";

    public URLListParameterView(URLListParameter parameter, ParameterView.Mode mode) {
        super(parameter, mode, new Object[0]);
        this.updateViewContents();
        this.updateCapabilityView();
        this.updateVisibilyView();
    }

    @Override
    public URLListParameter getParameter() {
        return (URLListParameter)super.getParameter();
    }

    @Override
    protected JComponent createConfigurationComponent(Object ... componentArgs) {
        return new URLConfigurationParameter();
    }

    @Override
    protected JComponent createReportComponent(Object ... componentArgs) {
        return new FileReportParameter();
    }

    protected abstract List<FileURLValue> askForFile(URLProtocol var1, Object ... var2);

    @Override
    protected void setEnabled(boolean isEnabled) {
        this.getComponent().setEnabled(isEnabled);
    }

    @Override
    protected void updateVisibilyView() {
        this.setVisible(this.getParameter().isVisible());
        this.fireVisibilityWasChanged();
    }

    @Override
    public boolean fillVerticalSpace() {
        return false;
    }

    @Override
    public void updateViewContents() {
        ((IURLParameterComponent)((Object)this.getComponent())).updateViewContents();
    }

    private class URLConfigurationParameter
    extends JPanel
    implements IURLParameterComponent {
        private final JButton addButton;
        private boolean isEnabledView;
        private JList list;
        private DefaultListModel model;
        private final JButton removeButton;
        private final JButton upButton;
        private final JButton dnButton;
        private JComboBox protocolCombo;
        private JComboBox sgaCombo;

        URLConfigurationParameter() {
            super(new BorderLayout());
            this.addButton = new JButton();
            this.removeButton = new JButton();
            this.upButton = new JButton();
            this.dnButton = new JButton();
            JPanel listPanel = this.createListPanel();
            this.updateSGAModel();
            this.add((Component)listPanel, "Center");
            URLListParameter parameter = URLListParameterView.this.getParameter();
            this.protocolChanged(parameter.getDefaultProtocol());
        }

        private JPanel createListPanel() {
            JPanel listPanel = new JPanel();
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.list.getSelectionModel().setSelectionMode(2);
            this.list.setToolTipText(URLListParameterView.this.getParameter().getDescription());
            this.list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    switch (keyCode) {
                        case 8: 
                        case 127: {
                            URLConfigurationParameter.this.removeFiles();
                        }
                    }
                }
            });
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    URLConfigurationParameter.this.updateRemoveButton();
                    URLConfigurationParameter.this.updateUpDownButton();
                }
            });
            this.list.setToolTipText(URLListParameterView.this.getParameter().getDescription());
            URLListParameter parameter = URLListParameterView.this.getParameter();
            EnumSet allowedProtocols = parameter.getAllowedProtocols();
            this.protocolCombo = new JComboBox();
            for (URLProtocol protocol : allowedProtocols) {
                this.protocolCombo.addItem(protocol);
            }
            this.protocolCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        URLProtocol item = (URLProtocol)e.getItem();
                        URLConfigurationParameter.this.protocolChanged(item);
                    }
                }
            });
            if (allowedProtocols.size() == 1) {
                this.protocolCombo.setVisible(false);
            }
            this.sgaCombo = new JComboBox();
            this.sgaCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        URLConfigurationParameter.this.model.clear();
                        URLConfigurationParameter.this.updateModel();
                    }
                }
            });
            JPanel buttonPanel = this.createButtonPanel();
            JPanel urlListPanel = new JPanel(new BorderLayout());
            urlListPanel.add((Component)new JScrollPane(this.list), "Center");
            urlListPanel.add((Component)buttonPanel, "East");
            listPanel.setLayout(new GridBagLayout());
            listPanel.add((Component)this.protocolCombo, new GBC(0, 0).horizontal().insets(2));
            listPanel.add((Component)this.sgaCombo, new GBC(1, 0).horizontal().insets(2));
            listPanel.add((Component)urlListPanel, new GBC(0, 1).gridwidth(2).fillx().insets(2, 2, 4, 2));
            return listPanel;
        }

        private JPanel createButtonPanel() {
            URLListParameter parameter = URLListParameterView.this.getParameter();
            this.addButton.setIcon(ApplicationImages.ICON_BROWSEFILE_16);
            this.addButton.setToolTipText(LNG.get((String)(LNGPREFIX + "add.button.tooltip")));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URLProtocol protocol = (URLProtocol)URLConfigurationParameter.this.protocolCombo.getSelectedItem();
                    List<FileURLValue> selectedUrls = URLListParameterView.this.askForFile(protocol, URLConfigurationParameter.this.getSGASelected());
                    if (selectedUrls != null) {
                        for (FileURLValue urlValue : selectedUrls) {
                            URLListParameterView.this.getParameter().addElement((Object)urlValue);
                        }
                    }
                }
            });
            this.removeButton.setIcon(ApplicationImages.ICON_DELETE_16);
            this.removeButton.setToolTipText(LNG.get((String)(LNGPREFIX + "del.button.tooltip")));
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URLConfigurationParameter.this.removeFiles();
                }
            });
            this.removeButton.setEnabled(false);
            this.upButton.setIcon(ApplicationImages.ICON_UP_16);
            this.upButton.setToolTipText(LNG.get((String)(LNGPREFIX + "up.button.tooltip")));
            this.upButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URLConfigurationParameter.this.moveUpFile();
                }
            });
            this.upButton.setEnabled(false);
            this.dnButton.setIcon(ApplicationImages.ICON_DOWN_16);
            this.dnButton.setToolTipText(LNG.get((String)(LNGPREFIX + "down.button.tooltip")));
            this.dnButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URLConfigurationParameter.this.moveDownFile();
                }
            });
            this.dnButton.setEnabled(false);
            ClientUtilities.adjustEqualSizes(this.addButton, this.removeButton, this.upButton, this.dnButton);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            buttonPanel.add((Component)this.addButton, new GBC(0, 0).center().none().insets(2));
            buttonPanel.add((Component)this.removeButton, new GBC(0, 1).center().none().insets(2));
            if (!parameter.mustSort()) {
                buttonPanel.add((Component)new JLabel(), new GBC(0, 2).center().vertical().insets(2));
                buttonPanel.add((Component)this.upButton, new GBC(0, 3).center().none().insets(2));
                buttonPanel.add((Component)this.dnButton, new GBC(0, 4).center().none().insets(2));
            }
            return buttonPanel;
        }

        private void removeFiles() {
            int[] selIdxs = this.list.getSelectedIndices();
            FileURLValue[] files = new FileURLValue[selIdxs.length];
            int i = 0;
            for (int selIdx : selIdxs) {
                ListModel listModel = this.list.getModel();
                FileURLValue file = (FileURLValue)listModel.getElementAt(selIdx);
                files[i++] = file;
            }
            URLListParameter parameter = URLListParameterView.this.getParameter();
            for (FileURLValue file : files) {
                parameter.removeElementObj((Object)file);
            }
        }

        private void moveUpFile() {
            int[] indexes = this.list.getSelectedIndices();
            int n = indexes.length;
            if (n != 1) {
                return;
            }
            int index = indexes[0];
            URLListParameter parameter = URLListParameterView.this.getParameter();
            parameter.moveUp(index);
            this.list.setSelectedIndex(index - 1);
        }

        private void moveDownFile() {
            int[] indexes = this.list.getSelectedIndices();
            int n = indexes.length;
            if (n != 1) {
                return;
            }
            int index = indexes[0];
            URLListParameter parameter = URLListParameterView.this.getParameter();
            parameter.moveDown(index);
            this.list.setSelectedIndex(index + 1);
        }

        private void updateRemoveButton() {
            this.removeButton.setEnabled(this.isEnabledView && !this.list.isSelectionEmpty());
        }

        private void updateUpDownButton() {
            int[] selection = this.list.getSelectedIndices();
            boolean flag = this.isEnabledView && !this.list.isSelectionEmpty() && selection.length == 1;
            this.upButton.setEnabled(flag);
            this.dnButton.setEnabled(flag);
        }

        private void updateSGAModel() {
            if (this.sgaCombo != null && this.sgaCombo.isVisible()) {
                List<String> sgaList = this.getSGAList();
                if (!this.isSGAListModified(sgaList)) {
                    return;
                }
                Object[] sgas = sgaList.toArray();
                if (sgaList.isEmpty()) {
                    this.sgaCombo.setEnabled(false);
                    String noSGAMessage = LNG.get((String)(LNGPREFIX + "no_sga"));
                    this.sgaCombo.setToolTipText(noSGAMessage);
                } else {
                    this.sgaCombo.setEnabled(true);
                    this.sgaCombo.setModel(new DefaultComboBoxModel<Object>(sgas));
                }
                this.addButton.setEnabled(this.sgaCombo.isEnabled());
            }
        }

        private boolean isSGAListModified(List<String> sgaList) {
            if (sgaList.size() == this.sgaCombo.getItemCount()) {
                for (int i = 0; i < this.sgaCombo.getItemCount(); ++i) {
                    if (this.sgaCombo.getItemAt(i).equals(sgaList.get(i))) continue;
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }

        private void protocolChanged(URLProtocol protocol) {
            this.model.clear();
            switch (protocol) {
                case LOCAL: {
                    this.sgaCombo.setVisible(false);
                    this.addButton.setIcon(ApplicationImages.ICON_BROWSELOCALFILE_16);
                    this.addButton.setVisible(true);
                    this.addButton.setEnabled(true);
                    this.list.setEnabled(true);
                    break;
                }
                case PROJECT: {
                    this.sgaCombo.setVisible(false);
                    this.addButton.setIcon(ApplicationImages.ICON_BROWSEFILE_16);
                    this.addButton.setVisible(true);
                    this.addButton.setEnabled(true);
                    this.list.setEnabled(true);
                    break;
                }
                case SGA: {
                    this.sgaCombo.setVisible(true);
                    this.addButton.setIcon(ApplicationImages.ICON_BROWSESGAFILE_16);
                    this.addButton.setVisible(true);
                    this.addButton.setEnabled(this.sgaCombo.isEnabled());
                    this.list.setEnabled(this.sgaCombo.isEnabled());
                    break;
                }
                default: {
                    this.sgaCombo.setVisible(false);
                    this.addButton.setVisible(false);
                    this.addButton.setEnabled(false);
                    this.list.setEnabled(true);
                }
            }
            this.updateSGAModel();
            this.updateModel();
        }

        private void updateModel() {
            if (this.model.getSize() == 0) {
                URLListParameterView.this.getParameter().setValue(null);
            } else {
                ArrayList<FileURLValue> urls = new ArrayList<FileURLValue>();
                for (int i = 0; i < this.model.getSize(); ++i) {
                    FileURLValue url = (FileURLValue)this.model.getElementAt(i);
                    urls.add(url);
                }
                URLListParameterView.this.getParameter().setValue(urls);
            }
        }

        @Override
        public void updateViewContents() {
            this.model.removeAllElements();
            List values = (List)URLListParameterView.this.getParameter().getValue();
            if (values != null) {
                FileURLValue url = (FileURLValue)values.iterator().next();
                if (url != null) {
                    if (this.protocolCombo != null) {
                        URLProtocol protocol = url.getProtocol();
                        this.protocolCombo.setSelectedItem(protocol);
                    }
                    if (this.sgaCombo != null) {
                        this.updateSGAModel();
                        String host = url.getHost();
                        if (host != null) {
                            this.sgaCombo.setSelectedItem(host);
                        }
                    }
                }
                for (FileURLValue value : values) {
                    this.model.addElement(value);
                }
            }
            this.updateModel();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.isEnabledView = isEnabled;
            super.setEnabled(isEnabled);
            this.list.setEnabled(isEnabled);
            this.addButton.setEnabled(isEnabled);
            this.addButton.setEnabled(isEnabled);
            this.updateRemoveButton();
            this.updateUpDownButton();
            if (this.protocolCombo != null) {
                this.protocolCombo.setEnabled(isEnabled);
            }
            if (this.sgaCombo != null) {
                this.sgaCombo.setEnabled(isEnabled);
            }
        }

        private String getSGASelected() {
            return (String)this.sgaCombo.getSelectedItem();
        }

        private List<String> getSGAList() {
            Vector<String> sgaNames = SGAProxy.getAllSGANames();
            if (sgaNames == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> sgaList = new ArrayList<String>();
            for (String name : sgaNames) {
                SGASet sgaSet = SGAProxy.getSGASet(name);
                if (!sgaSet.mayExecuteCommand()) continue;
                sgaList.add(name);
            }
            return sgaList;
        }
    }

    private class FileReportParameter
    extends JPanel
    implements IURLParameterComponent {
        private JTextArea textArea;

        FileReportParameter() {
            this.setLayout(new GridBagLayout());
            this.textArea = new JTextArea();
            URLListParameter parameter = URLListParameterView.this.getParameter();
            this.textArea.setToolTipText(parameter.getDescription());
            ComponentProperties.setProperties(this.textArea, ParameterView.Mode.REPORT, false);
            JScrollPane scroll = new JScrollPane(this.textArea);
            scroll.setBorder(ComponentProperties.getInstance(ParameterView.Mode.REPORT).getBorder());
            this.updateViewContents();
            this.add((Component)scroll, new GBC(0, 0).both());
        }

        @Override
        public void updateViewContents() {
            List values = (List)URLListParameterView.this.getParameter().getValue();
            if (values == null) {
                this.textArea.setRows(1);
            } else {
                this.textArea.setRows(Math.max(1, Math.min(values.size(), 6)));
                StringBuffer sb = new StringBuffer();
                for (FileURLValue value : values) {
                    URLProtocol selectedProtocol = value.getProtocol();
                    if (selectedProtocol == FileURLValue.DEFAULT_PROTOCOL) {
                        sb.append(value.getPath());
                    } else {
                        sb.append(selectedProtocol.getDisplayName() + value.getPath());
                    }
                    sb.append('\n');
                }
                String text = sb.substring(0, sb.length() - 1);
                this.textArea.setText(text);
            }
        }
    }

    private static interface IURLParameterComponent {
        public void updateViewContents();
    }
}

