/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.util;

import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.util.PreferencesUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class PreferencesEditorDialog
extends JDialog {
    private JButton ok;
    private JButton cancel;
    private PreferenceCategory pc;

    public PreferencesEditorDialog(Window parent, String title, PreferenceCategory pc, boolean isResizible, int w, int h) {
        super(parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        if (pc == null) {
            throw new IllegalArgumentException("pc n\u00e3o pode ser nulo.");
        }
        this.setLayout(new GridBagLayout());
        this.pc = pc;
        this.ok = new JButton("Ok");
        this.cancel = new JButton(LNG.get((String)"UTIL_CANCEL"));
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{this.ok, this.cancel});
        this.setButtonsAction();
        this.buildInterface();
        this.setLocationRelativeTo(this.getOwner());
        this.setMinimumSize(new Dimension(w, h));
        this.setResizable(isResizible);
        this.pack();
    }

    private void buildInterface() {
        JPanel panel = PreferencesUtil.createPreferencePanel(this.pc, false);
        JPanel buttonsPanel = this.createButtonsPanel();
        this.add((Component)panel, new GBC(0, 0).horizontal());
        this.add((Component)buttonsPanel, new GBC(0, 1).horizontal());
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)this.ok, new GBC(0, 0).none().top(5).left(10).right(10));
        buttonsPanel.add((Component)this.cancel, new GBC(1, 0).none().top(5).left(10).right(10));
        return buttonsPanel;
    }

    private void setButtonsAction() {
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PreferenceValue<?> pv : PreferencesEditorDialog.this.pc.getPreferences(PreferencePolicy.READ_ONLY, PreferencePolicy.READ_WRITE)) {
                    PreferenceEditor<?> editor = pv.getEditor();
                    editor.commit();
                    PreferencesEditorDialog.this.setVisible(false);
                }
                PreferenceManager.getInstance().savePreferences(PreferencesEditorDialog.this);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesEditorDialog.this.setVisible(false);
            }
        });
    }
}

