/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.project.ProjectFileContainer;
import csbase.client.util.SingletonFileChooser;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public abstract class CommonProjectAction
extends AbstractAction {
    protected static final String WAIT_DIALOG_TITLE = LNG.get((String)"GENERIC.title.wait");
    protected static final String ERROR_DIALOG_TITLE = LNG.get((String)"GENERIC.title.error");
    private ProjectFileContainer container;

    protected ClientProjectFile getSelectedFile() {
        return this.container.getSelectedFile();
    }

    protected ClientProjectFile[] getSelectedFiles() {
        return this.container.getSelectedFiles();
    }

    protected int getSelectionCount() {
        return this.container.getSelectionCount();
    }

    protected Window getWindow() {
        return this.container.getWindow();
    }

    protected String getTitle() {
        return this.container.getTitle();
    }

    protected CommonClientProject getProject() {
        return this.container.getProject();
    }

    protected void clearSelection() {
        this.container.clearSelection();
    }

    protected void clearClipboard() {
        this.container.clearClipboard();
    }

    protected void startRenamingAction() {
        this.container.startRenamingAction();
    }

    protected void startCutAction() {
        this.container.startCutAction();
    }

    protected void startCopyAction() {
        this.container.startCopyAction();
    }

    protected void startPasteAction() {
        this.container.startPasteAction();
    }

    protected JFileChooser getFileChooser() {
        return SingletonFileChooser.getInstance();
    }

    public CommonProjectAction(ProjectFileContainer container) {
        this.container = container;
        this.putValue("Name", this.getName());
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public abstract String getName();

    protected void showError(String msg) {
        this.showError(ERROR_DIALOG_TITLE, msg);
    }

    protected void showError(String title, String msg) {
        this.showError(this.getWindow(), title, msg);
    }

    protected void showError(Window parent, String msg) {
        this.showError(parent, ERROR_DIALOG_TITLE, msg);
    }

    protected void showError(Window parent, String title, String msg) {
        StandardDialogs.showErrorDialog((Component)parent, (String)title, (String)msg);
    }
}

