/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.table.column;

import csbase.client.applications.commandsmonitor.table.column.IColumn;
import csbase.logic.CommandInfo;
import csbase.logic.applicationservice.ApplicationRegistry;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractCommandsTableColumn
implements IColumn<CommandInfo> {
    private static final String KEY_DEFAULT_EMPTY_VALUE = "column.default.value.empty";
    private static final String KEY_DEFAULT_ERROR_VALUE = "column.default.value.error";
    private static final String KEY_TEMPLATE = "column.%s.%s";
    private static final String KEY_NAME = "name";
    private Class<?> clazz;
    private String columnId;
    private ApplicationRegistry appRegistry;
    private boolean editable;

    protected AbstractCommandsTableColumn(Class<?> clazz, String columnId, ApplicationRegistry appRegistry) {
        this(clazz, columnId, appRegistry, false);
    }

    protected AbstractCommandsTableColumn(Class<?> clazz, String columnId, ApplicationRegistry appRegistry, boolean editable) {
        this.clazz = clazz;
        this.columnId = columnId;
        this.appRegistry = appRegistry;
        this.editable = editable;
    }

    public final String getId() {
        return this.columnId;
    }

    @Override
    public final Class<?> getColumnClass() {
        return this.clazz;
    }

    @Override
    public final String getColumnName() {
        return this.getString(KEY_NAME, new Object[0]);
    }

    @Override
    public final boolean isColumnEditable() {
        return this.editable;
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        return null;
    }

    @Override
    public TableCellEditor createTableCellEditor() {
        return null;
    }

    @Override
    public void setValue(CommandInfo cmd, Object value) {
    }

    @Override
    public abstract Object getValue(CommandInfo var1);

    protected final String getString(String keySufix, Object ... args) {
        String key = String.format(KEY_TEMPLATE, this.columnId, keySufix);
        String text = this.appRegistry.getString(key);
        return String.format(text, args);
    }

    protected final String getGenericString(String key, Object ... args) {
        String text = this.appRegistry.getString(key);
        return String.format(text, args);
    }

    protected final String getDefaultEmptyValue() {
        return this.appRegistry.getString(KEY_DEFAULT_EMPTY_VALUE);
    }

    protected final String getDefaultErrorValue() {
        return this.appRegistry.getString(KEY_DEFAULT_ERROR_VALUE);
    }
}

