/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.sgamonitor.actions;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.sgamonitor.ClusterMonitor;
import csbase.client.applications.sgamonitor.SGAMonitor;
import csbase.client.applications.sgamonitor.SimpleServerMonitor;
import csbase.logic.SGASet;
import java.awt.event.ActionEvent;
import java.util.List;

public class DetailsSGAClusterAction
extends AbstractSimpleApplicationAction<SGAMonitor> {
    private ClusterMonitor clusterMonitor;
    private SimpleServerMonitor serverMonitor;

    public DetailsSGAClusterAction(SGAMonitor application) {
        super(application, ApplicationImages.ICON_DETAILS_16);
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        SGAMonitor app = (SGAMonitor)this.getApplication();
        List<SGASet> selectedSGAs = app.getSelectedSGAs();
        if (selectedSGAs.size() == 1) {
            SGASet sgaSelected = app.getSelectedSGAs().get(0);
            if (sgaSelected.isCluster()) {
                if (this.clusterMonitor == null) {
                    this.clusterMonitor = new ClusterMonitor((SGAMonitor)this.getApplication());
                    ((SGAMonitor)this.getApplication()).addObserver(this.clusterMonitor);
                }
                this.clusterMonitor.updateClusterInfo(sgaSelected);
                this.clusterMonitor.setVisible(true);
            } else {
                if (this.serverMonitor == null) {
                    this.serverMonitor = new SimpleServerMonitor((SGAMonitor)this.getApplication());
                    ((SGAMonitor)this.getApplication()).addObserver(this.serverMonitor);
                }
                this.serverMonitor.updateSGAInfo(sgaSelected);
                this.serverMonitor.setVisible(true);
            }
        }
    }
}

